/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl.client;

import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.net.HttpServletRequestResponseContext;
import org.opensaml.profile.RequestContextBuilder;
import org.opensaml.profile.action.ActionTestingSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.impl.client.AbstractBaseClientStorageServiceTest;
import org.opensaml.storage.impl.client.ClientStorageLoadContext;
import org.opensaml.storage.impl.client.ClientStorageService;
import org.opensaml.storage.impl.client.PopulateClientStorageLoadContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PopulateClientStorageLoadContextTest
extends AbstractBaseClientStorageServiceTest {
    private ProfileRequestContext prc;
    private PopulateClientStorageLoadContext action;

    @BeforeClass
    public void setUpClass() throws ComponentInitializationException {
        this.init();
    }

    @BeforeMethod
    public void setUp() {
        this.prc = new RequestContextBuilder().buildProfileRequestContext();
        this.action = new PopulateClientStorageLoadContext();
    }

    @Test
    public void testNoServices() throws ComponentInitializationException {
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"NoLoadNeeded");
        Assert.assertNull((Object)this.prc.getSubcontext(ClientStorageLoadContext.class));
    }

    @Test
    public void testUnloaded() throws ComponentInitializationException {
        this.action.setStorageServices(Collections.singletonList(this.getStorageService()));
        this.action.initialize();
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        ClientStorageLoadContext ctx = (ClientStorageLoadContext)this.prc.getSubcontext(ClientStorageLoadContext.class);
        Assert.assertNotNull((Object)ctx);
        Assert.assertEquals((int)ctx.getStorageKeys().size(), (int)1);
        Assert.assertTrue((boolean)ctx.getStorageKeys().contains("foo"));
    }

    @Test
    public void testLoaded() throws ComponentInitializationException {
        ClientStorageService ss = this.getStorageService();
        this.action.setStorageServices(Collections.singletonList(ss));
        this.action.initialize();
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        ss.load(null, ClientStorageService.ClientStorageSource.HTML_LOCAL_STORAGE);
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"NoLoadNeeded");
        ClientStorageLoadContext ctx = (ClientStorageLoadContext)this.prc.getSubcontext(ClientStorageLoadContext.class);
        Assert.assertNull((Object)ctx);
    }
}

