/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl.client;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.net.CookieManager;
import net.shibboleth.utilities.java.support.net.ThreadLocalHttpServletRequestProxy;
import net.shibboleth.utilities.java.support.net.ThreadLocalHttpServletResponseProxy;
import net.shibboleth.utilities.java.support.resource.Resource;
import net.shibboleth.utilities.java.support.resource.TestResourceConverter;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerKeyStrategy;
import net.shibboleth.utilities.java.support.security.impl.BasicKeystoreKeyStrategy;
import org.opensaml.storage.impl.client.ClientStorageService;
import org.springframework.core.io.ClassPathResource;
import org.testng.Assert;

public class AbstractBaseClientStorageServiceTest {
    public static final String STORAGE_NAME = "foo";
    private Resource keystoreResource;
    private Resource versionResource;

    protected void init() throws ComponentInitializationException {
        ClassPathResource resource = new ClassPathResource("/org/opensaml/storage/impl/SealerKeyStore.jks");
        Assert.assertTrue((boolean)resource.exists());
        this.keystoreResource = TestResourceConverter.of((org.springframework.core.io.Resource)resource);
        resource = new ClassPathResource("/org/opensaml/storage/impl/SealerKeyStore.kver");
        Assert.assertTrue((boolean)resource.exists());
        this.versionResource = TestResourceConverter.of((org.springframework.core.io.Resource)resource);
    }

    protected ClientStorageService getStorageService() throws ComponentInitializationException {
        ClientStorageService ss = new ClientStorageService();
        ss.setId("test");
        ss.setStorageName(STORAGE_NAME);
        CookieManager cm = new CookieManager();
        cm.setHttpServletRequest((HttpServletRequest)new ThreadLocalHttpServletRequestProxy());
        cm.setHttpServletResponse((HttpServletResponse)new ThreadLocalHttpServletResponseProxy());
        cm.initialize();
        ss.setCookieManager(cm);
        BasicKeystoreKeyStrategy strategy = new BasicKeystoreKeyStrategy();
        strategy.setKeyAlias("secret");
        strategy.setKeyPassword("kpassword");
        strategy.setKeystorePassword("password");
        strategy.setKeystoreResource(this.keystoreResource);
        strategy.setKeyVersionResource(this.versionResource);
        DataSealer sealer = new DataSealer();
        sealer.setKeyStrategy((DataSealerKeyStrategy)strategy);
        try {
            strategy.initialize();
            sealer.initialize();
        }
        catch (ComponentInitializationException e) {
            Assert.fail((String)e.getMessage());
        }
        ss.setDataSealer(sealer);
        ss.setHttpServletRequest((HttpServletRequest)new ThreadLocalHttpServletRequestProxy());
        ss.initialize();
        return ss;
    }
}

