/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl;

import java.io.IOException;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.persistence.EntityManagerFactory;
import net.shibboleth.ext.spring.util.ApplicationContextBuilder;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.StorageServiceTest;
import org.opensaml.storage.impl.JPAStorageService;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class JPAStorageServiceTest
extends StorageServiceTest {
    private JPAStorageService storageService;
    private Object[][] contexts;

    public JPAStorageServiceTest() {
        SecureRandom random1 = new SecureRandom();
        this.contexts = new Object[10][1];
        for (int i = 0; i < 10; ++i) {
            this.contexts[i] = new Object[]{Long.toString(random1.nextLong())};
        }
    }

    @BeforeClass
    public void setUp() throws ComponentInitializationException {
        this.storageService = new JPAStorageService(this.createEntityManagerFactory());
        this.storageService.setId("test");
        this.storageService.setCleanupInterval(Duration.ofSeconds(5L));
        this.storageService.setTransactionRetry(2);
        super.setUp();
    }

    private EntityManagerFactory createEntityManagerFactory() throws ComponentInitializationException {
        ClassPathResource resource = new ClassPathResource("/org/opensaml/storage/impl/jpa-spring-context.xml");
        GenericApplicationContext context = new ApplicationContextBuilder().setName("JPAStorageService").setServiceConfiguration((Resource)resource).build();
        FactoryBean factoryBean = (FactoryBean)context.getBean(LocalContainerEntityManagerFactoryBean.class);
        try {
            return (EntityManagerFactory)factoryBean.getObject();
        }
        catch (Exception e) {
            throw new ComponentInitializationException(e);
        }
    }

    @AfterClass
    protected void tearDown() {
        try {
            List contexts1 = this.storageService.readContexts();
            for (String ctx : contexts1) {
                this.storageService.deleteContext(ctx);
            }
            List recs = this.storageService.readAll();
            Assert.assertEquals((int)recs.size(), (int)0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        super.tearDown();
    }

    @Nonnull
    protected StorageService getStorageService() {
        return this.storageService;
    }

    @Test
    public void cleanup() throws ComponentInitializationException, IOException {
        String context = Long.toString(this.random.nextLong());
        for (int i = 1; i <= 100; ++i) {
            this.storageService.create(context, Integer.toString(i), Integer.toString(i + 1), Long.valueOf(System.currentTimeMillis() + 100L));
        }
        try {
            Thread.sleep(7500L);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        List recs = this.storageService.readAll(context);
        Assert.assertEquals((int)recs.size(), (int)0);
    }

    @DataProvider(name="contexts")
    public Object[][] contexts() throws Exception {
        return this.contexts;
    }

    @Test(dataProvider="contexts", singleThreaded=false, threadPoolSize=25, invocationCount=100)
    public void multithread(String context) throws IOException {
        this.shared.create(context, "mt", "bar", Long.valueOf(System.currentTimeMillis() + 300000L));
        StorageRecord rec = this.shared.read(context, "mt");
        Assert.assertNotNull((Object)rec);
        this.shared.update(context, "mt", "baz", Long.valueOf(System.currentTimeMillis() + 300000L));
        rec = this.shared.read(context, "mt");
        Assert.assertNotNull((Object)rec);
        boolean result = this.shared.create(context, "mt", "qux", null);
        Assert.assertFalse((boolean)result, (String)"createString should have failed");
    }

    @Test(singleThreaded=false, threadPoolSize=25, invocationCount=100)
    public void multithreadCaseSensitiveKey() throws IOException {
        this.shared.create("unit_test", "foo", "bar", null);
        this.shared.create("unit_test", "FOO", "bar", null);
        StorageRecord rec1 = this.shared.read("unit_test", "foo");
        StorageRecord rec2 = this.shared.read("unit_test", "FOO");
        Assert.assertNotNull((Object)rec1);
        Assert.assertNotNull((Object)rec2);
        Assert.assertNotEquals((Object)rec1, (Object)rec2);
    }

    @Test
    public void keyCollision() throws IOException {
        this.shared.create("unit_test", "dlo1", "value", null);
        this.shared.create("unit_test", "dn11", "value", null);
        StorageRecord rec1 = this.shared.read("unit_test", "dlo1");
        StorageRecord rec2 = this.shared.read("unit_test", "dn11");
        Assert.assertNotNull((Object)rec1);
        Assert.assertNotNull((Object)rec2);
        Assert.assertNotEquals((Object)rec1, (Object)rec2);
        this.shared.update("unit_test", "dlo1", "value2", null);
        this.shared.update("unit_test", "dn11", "value2", null);
        rec1 = this.shared.read("unit_test", "dlo1");
        rec2 = this.shared.read("unit_test", "dn11");
        Assert.assertNotNull((Object)rec1);
        Assert.assertNotNull((Object)rec2);
        Assert.assertNotEquals((Object)rec1, (Object)rec2);
        Assert.assertEquals((int)2, (int)this.storageService.readAll().size());
        Assert.assertEquals((int)2, (int)this.storageService.readAll("unit_test").size());
        this.shared.delete("unit_test", "dlo1");
        rec1 = this.shared.read("unit_test", "dlo1");
        rec2 = this.shared.read("unit_test", "dn11");
        Assert.assertNull((Object)rec1);
        Assert.assertNotNull((Object)rec2);
        this.shared.delete("unit_test", "dn11");
        rec1 = this.shared.read("unit_test", "dlo1");
        rec2 = this.shared.read("unit_test", "dn11");
        Assert.assertNull((Object)rec1);
        Assert.assertNull((Object)rec2);
    }

    @Test
    public void caseSensitiveContext() throws IOException {
        this.shared.create("foo", "bar", "value", null);
        this.shared.create("FOO", "bar", "value", null);
        StorageRecord rec1 = this.shared.read("foo", "bar");
        StorageRecord rec2 = this.shared.read("FOO", "bar");
        Assert.assertNotNull((Object)rec1);
        Assert.assertNotNull((Object)rec2);
        Assert.assertNotEquals((Object)rec1, (Object)rec2);
        this.shared.update("foo", "bar", "value2", null);
        this.shared.update("FOO", "bar", "value2", null);
        rec1 = this.shared.read("foo", "bar");
        rec2 = this.shared.read("FOO", "bar");
        Assert.assertNotNull((Object)rec1);
        Assert.assertNotNull((Object)rec2);
        Assert.assertNotEquals((Object)rec1, (Object)rec2);
        Assert.assertEquals((int)2, (int)this.storageService.readAll().size());
        Assert.assertEquals((int)1, (int)this.storageService.readAll("foo").size());
        Assert.assertEquals((int)1, (int)this.storageService.readAll("FOO").size());
        this.shared.delete("foo", "bar");
        rec1 = this.shared.read("foo", "bar");
        rec2 = this.shared.read("FOO", "bar");
        Assert.assertNull((Object)rec1);
        Assert.assertNotNull((Object)rec2);
        this.shared.delete("FOO", "bar");
        rec1 = this.shared.read("foo", "bar");
        rec2 = this.shared.read("FOO", "bar");
        Assert.assertNull((Object)rec1);
        Assert.assertNull((Object)rec2);
    }

    @Test
    public void caseSensitiveKey() throws IOException {
        this.shared.create("unit_test", "foo", "value", null);
        this.shared.create("unit_test", "FOO", "value", null);
        StorageRecord rec1 = this.shared.read("unit_test", "foo");
        StorageRecord rec2 = this.shared.read("unit_test", "FOO");
        Assert.assertNotNull((Object)rec1);
        Assert.assertNotNull((Object)rec2);
        Assert.assertNotEquals((Object)rec1, (Object)rec2);
        this.shared.update("unit_test", "foo", "value2", null);
        this.shared.update("unit_test", "FOO", "value2", null);
        rec1 = this.shared.read("unit_test", "foo");
        rec2 = this.shared.read("unit_test", "FOO");
        Assert.assertNotNull((Object)rec1);
        Assert.assertNotNull((Object)rec2);
        Assert.assertNotEquals((Object)rec1, (Object)rec2);
        Assert.assertEquals((int)2, (int)this.storageService.readAll().size());
        Assert.assertEquals((int)2, (int)this.storageService.readAll("unit_test").size());
        this.shared.delete("unit_test", "foo");
        rec1 = this.shared.read("unit_test", "foo");
        rec2 = this.shared.read("unit_test", "FOO");
        Assert.assertNull((Object)rec1);
        Assert.assertNotNull((Object)rec2);
        this.shared.delete("unit_test", "FOO");
        rec1 = this.shared.read("unit_test", "foo");
        rec2 = this.shared.read("unit_test", "FOO");
        Assert.assertNull((Object)rec1);
        Assert.assertNull((Object)rec2);
    }

    @Test(enabled=false)
    public void largeValue() throws IOException {
        StringBuilder sb = new StringBuilder(36000);
        for (int i = 0; i < 1000; ++i) {
            sb.append(UUID.randomUUID());
        }
        this.shared.create("unit_test", "large", sb.toString(), Long.valueOf(System.currentTimeMillis() + 300000L));
        StorageRecord rec = this.shared.read("unit_test", "large");
        Assert.assertNotNull((Object)rec);
        Assert.assertEquals((String)sb.toString(), (String)rec.getValue());
    }
}

