/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.RubyMotion;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.tasks.Builder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.jenkinsci.plugins.RubyMotion.RubyMotionBuilder;
import org.jenkinsci.plugins.RubyMotion.RubyMotionCommandLauncher;
import org.kohsuke.stapler.DataBoundConstructor;

public class RubyMotionBuilder
extends Builder {
    private final String platform;
    private final String rakeTask;
    private final String outputStyle;
    private final String outputFileName;
    private final boolean useBundler;
    private final boolean installCocoaPods;
    private final boolean needClean;
    private final String deviceFamily;
    private final String retina;
    private final String simulatorVersion;

    @DataBoundConstructor
    public RubyMotionBuilder(String platform, String rakeTask, String outputStyle, String outputFileName, boolean useBundler, boolean installCocoaPods, boolean needClean, String deviceFamily, String retina, String simulatorVersion) {
        this.platform = platform;
        this.rakeTask = rakeTask;
        this.outputStyle = outputStyle;
        this.outputFileName = outputFileName;
        this.useBundler = useBundler;
        this.installCocoaPods = installCocoaPods;
        this.needClean = needClean;
        this.deviceFamily = deviceFamily;
        this.retina = retina;
        this.simulatorVersion = simulatorVersion;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getRakeTask() {
        return this.rakeTask;
    }

    public String getDeviceFamily() {
        return this.deviceFamily;
    }

    public String getRetina() {
        return this.retina;
    }

    public String getOutputStyle() {
        return this.outputStyle;
    }

    public String getSimulatorVersion() {
        return this.simulatorVersion;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public boolean getUseBundler() {
        return this.useBundler;
    }

    public boolean getInstallCocoaPods() {
        return this.installCocoaPods;
    }

    public boolean getNeedClean() {
        return this.needClean;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        String cmds;
        boolean result;
        RubyMotionCommandLauncher cmdLauncher = new RubyMotionCommandLauncher(build, launcher, listener);
        if (this.useBundler && !(result = cmdLauncher.exec(cmds = "bundle install"))) {
            return false;
        }
        if (this.installCocoaPods) {
            cmds = "";
            if (this.useBundler) {
                cmds = "bundle exec ";
            }
            if (!(result = cmdLauncher.exec(cmds = cmds + "rake pod:install"))) {
                return false;
            }
        }
        if (this.needClean) {
            cmds = "";
            if (this.useBundler) {
                cmds = "bundle exec ";
            }
            if (!(result = cmdLauncher.exec(cmds = cmds + "rake clean"))) {
                return false;
            }
        }
        if (this.platform.equals("ios")) {
            return this.execiOS(cmdLauncher);
        }
        if (this.platform.equals("osx")) {
            return this.execOSX(cmdLauncher);
        }
        return false;
    }

    private boolean execOSX(RubyMotionCommandLauncher cmdLauncher) {
        String cmds = "rake ";
        if (this.getUseBundler()) {
            cmds = "bundle exec rake ";
        }
        cmds = cmds + this.rakeTask;
        cmds = cmds + " output=" + this.outputStyle;
        String output = cmdLauncher.getProjectWorkspace() + "/" + this.outputFileName;
        File outputFile = new File(output);
        if (outputFile.exists()) {
            outputFile.delete();
        }
        cmdLauncher.exec(cmds, outputFile);
        return this.checkFinishedWithoutCrash(cmdLauncher);
    }

    private boolean execiOS(RubyMotionCommandLauncher cmdLauncher) {
        String cmds = "rake ";
        if (this.getUseBundler()) {
            cmds = "bundle exec rake ";
        }
        cmds = cmds + this.rakeTask;
        if (this.simulatorVersion.length() > 0) {
            cmds = cmds + " target=" + this.simulatorVersion;
        }
        if (this.deviceFamily.equals("ipad")) {
            cmds = cmds + " retina=" + this.retina;
        } else if (this.retina.length() > 0 && this.simulatorVersion.length() > 0) {
            cmds = cmds + " retina=" + this.retina;
        }
        cmds = cmds + " device_family=" + this.deviceFamily;
        cmds = cmds + " output=" + this.outputStyle;
        String output = cmdLauncher.getProjectWorkspace() + "/" + this.outputFileName;
        String error = cmdLauncher.getProjectWorkspace() + "/.jenkins-error";
        File outputFile = new File(output);
        if (outputFile.exists()) {
            outputFile.delete();
        }
        File errorFile = new File(output);
        if (outputFile.exists()) {
            errorFile.delete();
        }
        cmds = cmds + " SIM_STDOUT_PATH='" + output + "' SIM_STDERR_PATH='" + error + "'";
        cmdLauncher.exec(cmds);
        return this.checkFinishedWithoutCrash(cmdLauncher);
    }

    private boolean checkFinishedWithoutCrash(RubyMotionCommandLauncher cmdLauncher) {
        String output = cmdLauncher.getProjectWorkspace() + "/" + this.outputFileName;
        String lastLine = null;
        try {
            BufferedReader in = new BufferedReader(new FileReader(output));
            String line = null;
            while ((line = in.readLine()) != null) {
                lastLine = line;
            }
            in.close();
        }
        catch (IOException e) {
            return false;
        }
        if (lastLine == null) {
            return false;
        }
        return lastLine.matches("^# \\d+ tests.+");
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }
}

