/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.RubyMotion;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import java.io.File;
import org.jenkinsci.plugins.RubyMotion.RubyMotionCommandLauncher;
import org.kohsuke.stapler.DataBoundConstructor;

public class RubyMotionBuilder
extends Builder {
    private final String platform;
    private final String rakeTask;
    private final String outputStyle;
    private final String outputFileName;
    private final boolean useBundler;
    private final boolean installCocoaPods;
    private final boolean needClean;
    private final String deviceFamily;
    private final String retina;
    private final String simulatorVersion;

    @DataBoundConstructor
    public RubyMotionBuilder(String platform, String rakeTask, String outputStyle, String outputFileName, boolean useBundler, boolean installCocoaPods, boolean needClean, String deviceFamily, String retina, String simulatorVersion) {
        this.platform = platform;
        this.rakeTask = rakeTask;
        this.outputStyle = outputStyle;
        this.outputFileName = outputFileName;
        this.useBundler = useBundler;
        this.installCocoaPods = installCocoaPods;
        this.needClean = needClean;
        this.deviceFamily = deviceFamily;
        this.retina = retina;
        this.simulatorVersion = simulatorVersion;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getRakeTask() {
        return this.rakeTask;
    }

    public String getDeviceFamily() {
        return this.deviceFamily;
    }

    public String getRetina() {
        return this.retina;
    }

    public String getOutputStyle() {
        return this.outputStyle;
    }

    public String getSimulatorVersion() {
        return this.simulatorVersion;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public boolean getUseBundler() {
        return this.useBundler;
    }

    public boolean getInstallCocoaPods() {
        return this.installCocoaPods;
    }

    public boolean getNeedClean() {
        return this.needClean;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        String cmds;
        boolean result;
        RubyMotionCommandLauncher cmdLauncher = new RubyMotionCommandLauncher(build, launcher, listener);
        if (this.useBundler && !(result = cmdLauncher.exec(cmds = "bundle install"))) {
            return false;
        }
        if (this.installCocoaPods) {
            cmds = "";
            if (this.useBundler) {
                cmds = "bundle exec ";
            }
            if (!(result = cmdLauncher.exec(cmds = cmds + "rake pod:install"))) {
                return false;
            }
        }
        if (this.needClean) {
            cmds = "";
            if (this.useBundler) {
                cmds = "bundle exec ";
            }
            if (!(result = cmdLauncher.exec(cmds = cmds + "rake clean"))) {
                return false;
            }
        }
        if (this.platform.equals("ios")) {
            return this.execiOS(cmdLauncher);
        }
        if (this.platform.equals("osx")) {
            return this.execOSX(cmdLauncher);
        }
        return false;
    }

    private boolean execOSX(RubyMotionCommandLauncher cmdLauncher) {
        String cmds = "rake ";
        if (this.getUseBundler()) {
            cmds = "bundle exec rake ";
        }
        cmds = cmds + this.rakeTask;
        cmds = cmds + " output=" + this.outputStyle;
        String output = cmdLauncher.getProjectWorkspace() + "/" + this.outputFileName;
        File outputFile = new File(output);
        if (outputFile.exists()) {
            outputFile.delete();
        }
        cmdLauncher.exec(cmds, outputFile);
        return true;
    }

    private boolean execiOS(RubyMotionCommandLauncher cmdLauncher) {
        String cmds = "rake ";
        if (this.getUseBundler()) {
            cmds = "bundle exec rake ";
        }
        cmds = cmds + this.rakeTask;
        if (this.simulatorVersion.length() > 0) {
            cmds = cmds + " target=" + this.simulatorVersion;
        }
        if (this.deviceFamily.equals("ipad")) {
            cmds = cmds + " retina=" + this.retina;
        } else if (this.retina.length() > 0 && this.simulatorVersion.length() > 0) {
            cmds = cmds + " retina=" + this.retina;
        }
        cmds = cmds + " device_family=" + this.deviceFamily;
        cmds = cmds + " output=" + this.outputStyle;
        String output = cmdLauncher.getProjectWorkspace() + "/" + this.outputFileName;
        String error = cmdLauncher.getProjectWorkspace() + "/.jenkins-error";
        File outputFile = new File(output);
        if (outputFile.exists()) {
            outputFile.delete();
        }
        File errorFile = new File(output);
        if (outputFile.exists()) {
            errorFile.delete();
        }
        cmds = cmds + " SIM_STDOUT_PATH='" + output + "' SIM_STDERR_PATH='" + error + "'";
        cmdLauncher.exec(cmds);
        return true;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "RubyMotion";
        }

        public ListBoxModel doFillPlatformItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("iOS Platform", "ios");
            items.add("OS X Platform", "osx");
            return items;
        }

        public ListBoxModel doFillRakeTaskItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("spec", "spec");
            return items;
        }

        public ListBoxModel doFillDeviceFamilyItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("iPhone", "iphone");
            items.add("iPad", "ipad");
            return items;
        }

        public ListBoxModel doFillRetinaItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("off", "false");
            items.add("on", "true");
            items.add("on (3.5-inch)", "3.5");
            items.add("on (4-inch)", "4");
            return items;
        }

        public ListBoxModel doFillOutputStyleItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("tap", "tap");
            return items;
        }
    }
}

