/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.RubyMotion;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RubyMotionCommandLauncher {
    private final AbstractBuild build;
    private final Launcher launcher;
    private final BuildListener listener;

    public RubyMotionCommandLauncher(AbstractBuild build, Launcher launcher, BuildListener listener) {
        this.build = build;
        this.launcher = launcher;
        this.listener = listener;
    }

    public String getProjectWorkspace() {
        return this.build.getProject().getWorkspace().toString();
    }

    public boolean exec(String command) {
        command = "bash -c \"" + command + "\"";
        try {
            int r = this.launcher.launch(command, this.build.getEnvVars(), (OutputStream)this.listener.getLogger(), this.build.getProject().getWorkspace()).join();
            return r == 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.listener.getLogger().println("IOException !");
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.listener.getLogger().println("InterruptedException !");
            return false;
        }
    }

    public boolean exec(String command, File outputFile) {
        command = "bash -c \"" + command + "\"";
        try {
            FileOutputStream outputStream = new FileOutputStream(outputFile);
            int r = this.launcher.launch(command, this.build.getEnvVars(), (OutputStream)outputStream, this.build.getProject().getWorkspace()).join();
            return r == 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.listener.getLogger().println("IOException !");
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.listener.getLogger().println("InterruptedException !");
            return false;
        }
    }
}

