/*
 * Decompiled with CFR 0.152.
 */
package jenkins.websocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Future;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jenkins.websocket.Provider;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class Jetty9Provider
implements Provider {
    private static final String ATTR_LISTENER = Jetty9Provider.class.getName() + ".listener";
    private static final Map<Provider.Listener, Session> sessions = Collections.synchronizedMap(new WeakHashMap());
    private WebSocketServletFactory factory;

    public Jetty9Provider() {
        WebSocketServletFactory.class.hashCode();
    }

    private synchronized void init(HttpServletRequest req) throws Exception {
        if (this.factory == null) {
            this.factory = WebSocketServletFactory.Loader.load((ServletContext)req.getServletContext(), (WebSocketPolicy)WebSocketPolicy.newServerPolicy());
            this.factory.start();
            this.factory.setCreator(Jetty9Provider::createWebSocket);
        }
    }

    public Provider.Handler handle(HttpServletRequest req, HttpServletResponse rsp, final Provider.Listener listener) throws Exception {
        this.init(req);
        req.setAttribute(ATTR_LISTENER, (Object)listener);
        if (!this.factory.isUpgradeRequest(req, rsp)) {
            rsp.sendError(400, "only WS connections accepted here");
            return null;
        }
        if (!this.factory.acceptWebSocket(req, rsp)) {
            rsp.sendError(400, "did not manage to upgrade");
            return null;
        }
        return new Provider.Handler(){

            public Future<Void> sendBinary(ByteBuffer data) throws IOException {
                return this.session().getRemote().sendBytesByFuture(data);
            }

            public void sendBinary(ByteBuffer partialByte, boolean isLast) throws IOException {
                this.session().getRemote().sendPartialBytes(partialByte, isLast);
            }

            public Future<Void> sendText(String text) throws IOException {
                return this.session().getRemote().sendStringByFuture(text);
            }

            public void sendPing(ByteBuffer applicationData) throws IOException {
                this.session().getRemote().sendPing(applicationData);
            }

            public void close() throws IOException {
                this.session().close();
            }

            private Session session() {
                Session session = sessions.get(listener);
                if (session == null) {
                    throw new IllegalStateException("missing session");
                }
                return session;
            }
        };
    }

    private static Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
        final Provider.Listener listener = (Provider.Listener)req.getHttpServletRequest().getAttribute(ATTR_LISTENER);
        if (listener == null) {
            throw new IllegalStateException("missing listener attribute");
        }
        return new WebSocketListener(){

            public void onWebSocketBinary(byte[] payload, int offset, int length) {
                listener.onWebSocketBinary(payload, offset, length);
            }

            public void onWebSocketText(String message) {
                listener.onWebSocketText(message);
            }

            public void onWebSocketClose(int statusCode, String reason) {
                listener.onWebSocketClose(statusCode, reason);
            }

            public void onWebSocketConnect(Session session) {
                sessions.put(listener, session);
                listener.onWebSocketConnect();
            }

            public void onWebSocketError(Throwable cause) {
                listener.onWebSocketError(cause);
            }
        };
    }
}

