// CHECKSTYLE:OFF

package hudson.cli.client;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Jenkins CLI
     * Usage: java -jar jenkins-cli.jar [-s URL] command [opts...] args...
     * Options:
     * -s URL       : the server URL (defaults to the JENKINS_URL env var)
     * -i KEY       : SSH private key file used for authentication
     * -p HOST:PORT : HTTP proxy host and port for HTTPS proxy tunneling. See http://jenkins-ci.org/https-proxy-tunnel
     * -noCertificateCheck : bypass HTTPS certificate check entirely. Use with caution
     * 
     * The available commands depend on the server. Run the 'help' command to
     * see the list.
     * 
     */
    public static String CLI_Usage() {
        return holder.format("CLI.Usage");
    }

    /**
     * Jenkins CLI
     * Usage: java -jar jenkins-cli.jar [-s URL] command [opts...] args...
     * Options:
     * -s URL       : the server URL (defaults to the JENKINS_URL env var)
     * -i KEY       : SSH private key file used for authentication
     * -p HOST:PORT : HTTP proxy host and port for HTTPS proxy tunneling. See http://jenkins-ci.org/https-proxy-tunnel
     * -noCertificateCheck : bypass HTTPS certificate check entirely. Use with caution
     * 
     * The available commands depend on the server. Run the 'help' command to
     * see the list.
     * 
     */
    public static Localizable _CLI_Usage() {
        return new Localizable(holder, "CLI.Usage");
    }

    /**
     * Neither -s nor the JENKINS_URL env var is specified.
     * 
     */
    public static String CLI_NoURL() {
        return holder.format("CLI.NoURL");
    }

    /**
     * Neither -s nor the JENKINS_URL env var is specified.
     * 
     */
    public static Localizable _CLI_NoURL() {
        return new Localizable(holder, "CLI.NoURL");
    }

    /**
     * No such file exists: {0}
     * 
     */
    public static String CLI_NoSuchFileExists(Object arg1) {
        return holder.format("CLI.NoSuchFileExists", arg1);
    }

    /**
     * No such file exists: {0}
     * 
     */
    public static Localizable _CLI_NoSuchFileExists(Object arg1) {
        return new Localizable(holder, "CLI.NoSuchFileExists", arg1);
    }

    /**
     * Version mismatch. This CLI cannot work with this Jenkins server.
     * 
     */
    public static String CLI_VersionMismatch() {
        return holder.format("CLI.VersionMismatch");
    }

    /**
     * Version mismatch. This CLI cannot work with this Jenkins server.
     * 
     */
    public static Localizable _CLI_VersionMismatch() {
        return new Localizable(holder, "CLI.VersionMismatch");
    }

}
