/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.jruby;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.AbstractReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Field;
import org.jenkinsci.jruby.JRubyMapper;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.proxy.InternalJavaProxy;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.javasupport.proxy.JavaProxyInvocationHandler;
import org.jruby.javasupport.proxy.JavaProxyMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaProxyConverter
implements Converter {
    private final ReflectionProvider reflectionProvider;
    private final AbstractReflectionConverter reflectionConverter;

    public JavaProxyConverter(XStream owner, AbstractReflectionConverter reflectionConverter) {
        this.reflectionConverter = reflectionConverter;
        this.reflectionProvider = owner.getReflectionProvider();
    }

    public boolean canConvert(Class type) {
        return InternalJavaProxy.class.isAssignableFrom(type) || JRubyMapper.DynamicProxy.class == type;
    }

    public void marshal(Object o, HierarchicalStreamWriter writer, MarshallingContext context) {
        InternalJavaProxy p = (InternalJavaProxy)o;
        IRubyObject base = p.___getInvocationHandler().getOrig();
        writer.startNode("ruby-object");
        context.convertAnother((Object)base);
        writer.endNode();
        this.reflectionConverter.marshal(o, writer, context);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        reader.moveDown();
        JavaProxy original = (JavaProxy)context.convertAnother(null, IRubyObject.class);
        reader.moveUp();
        JavaProxyClass realProxyClass = this.getProxyClass(original);
        Class realClass = realProxyClass.getJavaClass();
        Object javaObject = this.reflectionProvider.newInstance(realClass);
        original.setObject(javaObject);
        try {
            Field h = realClass.getDeclaredField("__handler");
            h.setAccessible(true);
            h.set(javaObject, new InvocationHandlerImpl((IRubyObject)original));
        }
        catch (NoSuchFieldException e) {
            throw new Error(e);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        this.reflectionConverter.doUnmarshal(javaObject, reader, context);
        return javaObject;
    }

    private JavaProxyClass getProxyClass(JavaProxy original) {
        IRubyObject proxyClass = original.getMetaClass().getInstanceVariables().fastGetInstanceVariable("@java_proxy_class");
        if (proxyClass == null || proxyClass.isNil()) {
            proxyClass = JavaProxyClass.get_with_class((IRubyObject)original, (IRubyObject)original.getMetaClass());
            original.getMetaClass().getInstanceVariables().fastSetInstanceVariable("@java_proxy_class", proxyClass);
        }
        return (JavaProxyClass)proxyClass;
    }

    private static class InvocationHandlerImpl
    implements JavaProxyInvocationHandler {
        private final IRubyObject self;
        private final Ruby runtime;

        private InvocationHandlerImpl(IRubyObject self) {
            this.self = self;
            this.runtime = self.getRuntime();
        }

        public IRubyObject getOrig() {
            return this.self;
        }

        public Object invoke(Object proxy, JavaProxyMethod m, Object[] nargs) throws Throwable {
            String name = m.getName();
            DynamicMethod method = this.self.getMetaClass().searchMethod(name);
            int v = method.getArity().getValue();
            IRubyObject[] newArgs = new IRubyObject[nargs.length];
            int i = nargs.length;
            while (--i >= 0) {
                newArgs[i] = JavaUtil.convertJavaToUsableRubyObject((Ruby)this.runtime, (Object)nargs[i]);
            }
            IRubyObject result = null;
            if (v < 0 || v == newArgs.length) {
                result = method.call(this.runtime.getCurrentContext(), this.self, (RubyModule)this.self.getMetaClass(), name, newArgs);
            } else if (m.hasSuperImplementation()) {
                RubyClass superClass = this.self.getMetaClass().getSuperClass();
                result = RuntimeHelpers.invokeAs((ThreadContext)this.runtime.getCurrentContext(), (RubyClass)superClass, (IRubyObject)this.self, (String)name, (IRubyObject[])newArgs, (Block)Block.NULL_BLOCK);
            } else {
                throw this.runtime.newArgumentError(newArgs.length, v);
            }
            if (m.getReturnType() == Void.TYPE) {
                return null;
            }
            return result.toJava(m.getReturnType());
        }
    }
}

