/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.jruby;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.List;
import org.jenkinsci.jruby.RubyRuntimeResolver;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubySymbol;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;

public class JRubyXStreamConverter
implements Converter {
    private final RubyRuntimeResolver resolver;
    private final XStream xs;
    protected final Mapper mapper;

    public JRubyXStreamConverter(XStream xs, RubyRuntimeResolver resolver) {
        this.xs = xs;
        this.resolver = resolver;
        this.mapper = xs.getMapper();
    }

    public boolean canConvert(Class type) {
        return IRubyObject.class.isAssignableFrom(type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        RubyBasicObject o = (RubyBasicObject)source;
        RubyClass t = o.getType();
        writer.addAttribute("ruby-class", t.getName());
        Ruby runtime = o.getRuntime();
        this.resolver.marshal((IRubyObject)o, writer, context);
        boolean hasTransient = t.getType().getMethods().containsKey("transient?");
        for (Variable v : o.getVariableList()) {
            Object value = v.getValue();
            if (value == null) continue;
            String vname = v.getName().substring(1);
            if (hasTransient && t.callMethod("transient?", new IRubyObject[]{runtime.newString(vname)}).isTrue()) continue;
            writer.startNode(vname);
            if (!(value instanceof IRubyObject)) {
                Class<?> valueType = value.getClass();
                String serializedClassName = this.mapper.serializedClass(valueType);
                writer.addAttribute("class", serializedClassName);
            }
            context.convertAnother(value);
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Converter cnv;
        String className;
        Ruby runtime = this.resolver.unmarshal(reader, context);
        RubyClass c = this.resolveClass(runtime, className = reader.getAttribute("ruby-class"));
        if (c == null) {
            throw new IllegalArgumentException("Undefined class: " + className);
        }
        Class r = c.getReifiedClass();
        if (r != null && (cnv = this.xs.getConverterLookup().lookupConverterForType(r)) != this) {
            return cnv.unmarshal(reader, context);
        }
        IRubyObject o = c.allocate();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String fieldName = reader.getNodeName();
            className = reader.getAttribute("class");
            Class valueType = className != null ? this.mapper.realClass(className) : IRubyObject.class;
            IRubyObject value = (IRubyObject)context.convertAnother((Object)o, valueType);
            c.getVariableAccessorForWrite('@' + fieldName).set((Object)o, (Object)value);
            reader.moveUp();
        }
        this.callReadCompleted(o);
        return o;
    }

    private void callReadCompleted(IRubyObject o) {
        Ruby runtime = o.getRuntime();
        RubySymbol read_completed = runtime.newSymbol("read_completed");
        List ancestors = o.getType().getAncestorList();
        for (int i = ancestors.size() - 1; i >= 0; --i) {
            RubyModule t = (RubyModule)ancestors.get(i);
            if (!t.callMethod("method_defined?", new IRubyObject[]{read_completed}).isTrue() && !t.callMethod("private_method_defined?", new IRubyObject[]{read_completed}).isTrue()) continue;
            ThreadContext c = runtime.getCurrentContext();
            IRubyObject m = t.callMethod("instance_method", new IRubyObject[]{read_completed});
            m.callMethod(c, "bind", o).callMethod(c, "call");
        }
    }

    private RubyClass resolveClass(Ruby runtime, String className) {
        RubyClass cur = runtime.getObject();
        for (String token : className.split("::")) {
            IRubyObject o = cur.getConstantAt(token);
            if (!(o instanceof RubyModule)) {
                return null;
            }
            cur = (RubyModule)o;
        }
        if (cur instanceof RubyClass) {
            return cur;
        }
        return null;
    }
}

