/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.jruby;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.jenkinsci.jruby.RubyRuntimeResolver;
import org.jruby.Ruby;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRubyPrimitiveValueConverter<T extends IRubyObject>
implements Converter {
    protected final RubyRuntimeResolver resolver;
    protected final Class<T> type;

    protected abstract T fromString(Ruby var1, String var2);

    protected abstract String toString(T var1);

    protected AbstractRubyPrimitiveValueConverter(RubyRuntimeResolver resolver, Class<T> type) {
        this.resolver = resolver;
        this.type = type;
    }

    public boolean canConvert(Class type) {
        return type == this.type;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        IRubyObject o = (IRubyObject)source;
        this.resolver.marshal(o, writer, context);
        writer.addAttribute("ruby-class", o.getType().getName());
        writer.setValue(this.toString((IRubyObject)source));
    }

    public T unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Ruby runtime = this.resolver.unmarshal(reader, context);
        return this.fromString(runtime, reader.getValue());
    }
}

