/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.jruby;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyHashConverter
implements Converter {
    private final Ruby runtime;

    public RubyHashConverter(Ruby runtime) {
        this.runtime = runtime;
    }

    public boolean canConvert(Class type) {
        return type == RubyHash.class;
    }

    public void marshal(Object o, HierarchicalStreamWriter writer, MarshallingContext context) {
        RubyHash hash = (RubyHash)o;
        writer.addAttribute("ruby-class", hash.getType().getName());
        for (Map.Entry e : hash.directEntrySet()) {
            writer.startNode("entry");
            writer.startNode("key");
            context.convertAnother(e.getKey());
            writer.endNode();
            writer.startNode("value");
            context.convertAnother(e.getValue());
            writer.endNode();
            writer.endNode();
        }
    }

    public RubyHash unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        RubyHash hash = RubyHash.newHash((Ruby)this.runtime);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            reader.moveDown();
            IRubyObject key = (IRubyObject)context.convertAnother(null, IRubyObject.class);
            reader.moveUp();
            reader.moveDown();
            IRubyObject value = (IRubyObject)context.convertAnother(null, IRubyObject.class);
            reader.moveUp();
            hash.op_aset(key, value);
            reader.moveUp();
        }
        return hash;
    }
}

