/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.jruby;

import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import org.jruby.RubyBasicObject;
import org.jruby.javasupport.proxy.InternalJavaProxy;

public class JRubyMapper
extends MapperWrapper {
    private static final String RUBY_PROXY = "ruby-proxy-object";
    private static final String RUBY_OBJECT = "ruby-object";

    public JRubyMapper(Mapper wrapped) {
        super(wrapped);
    }

    public String serializedClass(Class type) {
        if (type != null && InternalJavaProxy.class.isAssignableFrom(type)) {
            return RUBY_PROXY;
        }
        if (type != null && RubyBasicObject.class.isAssignableFrom(type)) {
            return RUBY_OBJECT;
        }
        return super.serializedClass(type);
    }

    public Class realClass(String elementName) {
        if (elementName.equals(RUBY_PROXY)) {
            return DynamicProxy.class;
        }
        if (elementName.equals(RUBY_OBJECT)) {
            return RubyBasicObject.class;
        }
        return super.realClass(elementName);
    }

    public boolean shouldSerializeMember(Class definedIn, String fieldName) {
        if (InternalJavaProxy.class.isAssignableFrom(definedIn) && fieldName.equals("__handler")) {
            return false;
        }
        return super.shouldSerializeMember(definedIn, fieldName);
    }

    public static class DynamicProxy {
    }
}

