/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.functions;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.jclouds.elasticstack.domain.ClaimType;
import org.jclouds.elasticstack.domain.ImageConversionType;
import org.jclouds.elasticstack.domain.MediaType;
import org.jclouds.elasticstack.domain.StandardDrive;
import org.jclouds.elasticstack.functions.ListOfKeyValuesDelimitedByBlankLinesToListOfMaps;
import org.jclouds.elasticstack.functions.MapToStandardDrive;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class MapToStandardDriveTest {
    public static final StandardDrive ONE = new StandardDrive.Builder().name("Windows Web Server 2008 R2").uuid("11b84345-7169-4279-8038-18d6ba1a7712").claimType(ClaimType.SHARED).readers((Iterable)ImmutableSet.of((Object)"ffffffff-ffff-ffff-ffff-ffffffffffff")).size(4743757824L).rawSize(0x2C0000000L).format(ImageConversionType.GZIP).media(MediaType.DISK).build();
    private static final MapToStandardDrive MAP_TO_STANDARD_DRIVE = new MapToStandardDrive();

    public void testEmptyMapReturnsNull() {
        Assert.assertEquals((Object)MAP_TO_STANDARD_DRIVE.apply((Map)ImmutableMap.of()), null);
    }

    public void testBasics() {
        StandardDrive expects = new StandardDrive.Builder().name("foo").size(100L).media(MediaType.DISK).format(ImageConversionType.GZIP).rawSize(5L).build();
        Assert.assertEquals((Object)MAP_TO_STANDARD_DRIVE.apply((Map)ImmutableMap.of((Object)"name", (Object)"foo", (Object)"size", (Object)"100", (Object)"format", (Object)"gzip", (Object)"media", (Object)"disk", (Object)"rawsize", (Object)"5")), (Object)expects);
    }

    public void testComplete() throws IOException {
        Map input = (Map)new ListOfKeyValuesDelimitedByBlankLinesToListOfMaps().apply(Strings2.toStringAndClose((InputStream)MapToStandardDriveTest.class.getResourceAsStream("/standard_drive.txt"))).get(0);
        Assert.assertEquals((Object)MAP_TO_STANDARD_DRIVE.apply(input), (Object)ONE);
    }
}

