/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.inject.Module;
import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import com.squareup.okhttp.mockwebserver.RecordedRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Set;
import org.jclouds.elasticstack.ElasticStackApi;
import org.jclouds.http.BaseMockWebServerTest;
import org.jclouds.http.config.JavaUrlHttpCommandExecutorServiceModule;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ElasticStackMockTest")
public class ElasticStackMockTest
extends BaseMockWebServerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testListStandardDrives() throws IOException, InterruptedException {
        MockWebServer server = ElasticStackMockTest.mockWebServer((MockResponse[])new MockResponse[]{new MockResponse().setBody(this.payloadFromResource("/standard_drives_uuids.txt"))});
        ElasticStackApi api = (ElasticStackApi)this.api(ElasticStackApi.class, server.getUrl("/").toString());
        try {
            Set standardDrives = api.listStandardDrives();
            Assert.assertEquals((int)standardDrives.size(), (int)36);
            RecordedRequest request = server.takeRequest();
            ElasticStackMockTest.assertAuthentication(request);
            Assert.assertEquals((String)request.getRequestLine(), (String)"GET /drives/list/standard HTTP/1.1");
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testListStandardDriveInfo() throws IOException, InterruptedException {
        MockWebServer server = ElasticStackMockTest.mockWebServer((MockResponse[])new MockResponse[]{new MockResponse().setBody(this.payloadFromResource("/standard_drives.txt"))});
        ElasticStackApi api = (ElasticStackApi)this.api(ElasticStackApi.class, server.getUrl("/").toString());
        try {
            Set standardDrives = api.listStandardDriveInfo();
            Assert.assertEquals((int)standardDrives.size(), (int)36);
            RecordedRequest request = server.takeRequest();
            ElasticStackMockTest.assertAuthentication(request);
            Assert.assertEquals((String)request.getRequestLine(), (String)"GET /drives/info/standard HTTP/1.1");
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    private static void assertAuthentication(RecordedRequest request) throws InterruptedException {
        Assert.assertEquals((String)request.getHeader("Authorization"), (String)"Basic dXVpZDphcGlrZXk=");
    }

    private byte[] payloadFromResource(String resource) {
        try {
            return Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(resource)).getBytes(Charsets.UTF_8);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected void addOverrideProperties(Properties props) {
        props.setProperty("jclouds.identity", "uuid");
        props.setProperty("jclouds.credential", "apikey");
    }

    protected Module createConnectionModule() {
        return new JavaUrlHttpCommandExecutorServiceModule();
    }
}

