/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.compute.functions;

import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import org.jclouds.elasticstack.compute.functions.ServerInfoToNodeMetadata;
import org.jclouds.elasticstack.domain.Device;
import org.jclouds.elasticstack.domain.DriveInfo;
import org.jclouds.elasticstack.domain.DriveMetrics;
import org.jclouds.elasticstack.domain.SCSIDevice;
import org.jclouds.elasticstack.domain.Server;
import org.jclouds.elasticstack.domain.VNC;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="GetImageIdFromServerTest")
public class GetImageIdFromServerTest {
    private static final String UNKNOWN_DRIVE_UUID = UUID.randomUUID().toString();
    private LoadingCache<String, DriveInfo> knownDrives = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, DriveInfo>(){

        public DriveInfo load(String key) throws Exception {
            return UNKNOWN_DRIVE_UUID.equals(key) ? null : new DriveInfo.Builder().name("foo").metrics(new DriveMetrics.Builder().build()).build();
        }
    });
    private ServerInfoToNodeMetadata.GetImageIdFromServer function = new ServerInfoToNodeMetadata.GetImageIdFromServer(this.knownDrives);

    public void testImageIdExists() {
        Map<String, Device> devices = GetImageIdFromServerTest.deviceMapFor(UUID.randomUUID().toString());
        Server server = GetImageIdFromServerTest.serverFor(devices, devices.keySet());
        Assert.assertEquals((String)this.function.apply(server), (String)"foo");
    }

    public void testImageIdExistsAndUsesTheFirstDevice() {
        Map<String, Device> devices = GetImageIdFromServerTest.deviceMapFor(UUID.randomUUID().toString(), UNKNOWN_DRIVE_UUID);
        Server server = GetImageIdFromServerTest.serverFor(devices, devices.keySet());
        Assert.assertEquals((String)this.function.apply(server), (String)"foo");
    }

    public void testImageIdIsNullWhenNoBootableDevices() {
        Map<String, Device> devices = GetImageIdFromServerTest.deviceMapFor(UUID.randomUUID().toString());
        Server server = GetImageIdFromServerTest.serverFor(devices, (Iterable<String>)ImmutableSet.of());
        Assert.assertNull((Object)this.function.apply(server));
    }

    public void testImageIdIsNullWhenNoDeviceWithGivenId() {
        Map<String, Device> devices = GetImageIdFromServerTest.deviceMapFor(UUID.randomUUID().toString());
        Server server = GetImageIdFromServerTest.serverFor((Map<String, Device>)ImmutableMap.of(), devices.keySet());
        Assert.assertNull((Object)this.function.apply(server));
    }

    private static Map<String, Device> deviceMapFor(String ... uuids) {
        ImmutableSet.Builder devices = ImmutableSet.builder();
        for (int i = 0; i < uuids.length; ++i) {
            devices.add((Object)new SCSIDevice.Builder(i).uuid(uuids[i]).build());
        }
        return Maps.uniqueIndex((Iterable)devices.build(), (Function)new Function<Device, String>(){

            public String apply(Device input) {
                return input.getId();
            }
        });
    }

    private static Server serverFor(Map<String, Device> devices, Iterable<String> deviceIds) {
        return new Server.Builder().name("test").vnc(new VNC(null, null, false)).devices(devices).bootDeviceIds(deviceIds).build();
    }
}

