/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.compute;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.UUID;
import org.easymock.EasyMock;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.VolumeBuilder;
import org.jclouds.compute.domain.internal.TemplateImpl;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.elasticstack.ElasticStackApi;
import org.jclouds.elasticstack.compute.ElasticStackComputeServiceAdapter;
import org.jclouds.elasticstack.domain.Drive;
import org.jclouds.elasticstack.domain.DriveInfo;
import org.jclouds.elasticstack.domain.DriveMetrics;
import org.jclouds.elasticstack.domain.ImageConversionType;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.testng.collections.Maps;

@Test(groups={"unit"}, testName="ElasticStackComputeServiceAdapterTest")
public class ElasticStackComputeServiceAdapterTest {
    private Image image;
    private Hardware hardware;
    private Template template;

    @BeforeMethod
    public void setup() {
        this.image = new ImageBuilder().ids("mock").operatingSystem(OperatingSystem.builder().description("mock").build()).status(Image.Status.AVAILABLE).build();
        this.hardware = new HardwareBuilder().ids("mock").volume(new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(1.0f)).build()).processor(new Processor(1.0, 1.0)).build();
        this.template = new TemplateImpl(this.image, this.hardware, new LocationBuilder().id("mock").scope(LocationScope.PROVIDER).description("mock").build(), TemplateOptions.NONE);
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="imageDrive call failed")
    public void testDiskIsDestroyedIfImageFails() {
        Supplier preInstalledImageSupplier = Suppliers.ofInstance((Object)Maps.newHashMap());
        LoadingCache driveCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, DriveInfo>(){

            public DriveInfo load(String key) throws Exception {
                throw new IllegalStateException("cache should not be used");
            }
        });
        ElasticStackApi api = (ElasticStackApi)EasyMock.createMock(ElasticStackApi.class);
        Predicate driveNotClaimed = Predicates.alwaysTrue();
        DriveInfo mockDrive = new DriveInfo.Builder().uuid(UUID.randomUUID().toString()).name("mock").metrics(new DriveMetrics.Builder().build()).build();
        EasyMock.expect((Object)api.createDrive((Drive)EasyMock.anyObject(DriveInfo.class))).andReturn((Object)mockDrive);
        api.imageDrive(this.image.getId(), mockDrive.getUuid(), ImageConversionType.GUNZIP);
        EasyMock.expectLastCall().andThrow((Throwable)new IllegalStateException("imageDrive call failed"));
        api.destroyDrive(mockDrive.getUuid());
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{api});
        ElasticStackComputeServiceAdapter adapter = new ElasticStackComputeServiceAdapter(api, driveNotClaimed, preInstalledImageSupplier, driveCache, "12345678", MoreExecutors.newDirectExecutorService());
        try {
            adapter.createNodeWithGroupEncodedIntoName("mock-group", "mock-name", this.template);
        }
        catch (IllegalStateException ex) {
            EasyMock.verify((Object[])new Object[]{api});
            throw ex;
        }
    }
}

