/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.velocity;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NullableElements;
import net.shibboleth.shared.spring.velocity.VelocityConfig;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.view.AbstractTemplateView;

public class VelocityView
extends AbstractTemplateView {
    @Nullable
    private String encoding;
    private boolean cacheTemplate;
    @Nullable
    private VelocityEngine velocityEngine;
    @Nullable
    private Template template;

    public void setEncoding(@Nullable String enc) {
        this.encoding = enc;
    }

    @Nullable
    protected String getEncoding() {
        return this.encoding;
    }

    public void setCacheTemplate(boolean flag) {
        this.cacheTemplate = flag;
    }

    protected boolean isCacheTemplate() {
        return this.cacheTemplate;
    }

    public void setVelocityEngine(@Nullable VelocityEngine engine) {
        this.velocityEngine = engine;
    }

    @Nullable
    protected VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    protected void initApplicationContext() throws BeansException {
        super.initApplicationContext();
        if (this.getVelocityEngine() == null) {
            this.setVelocityEngine(this.autodetectVelocityEngine());
        }
    }

    @Nonnull
    protected VelocityEngine autodetectVelocityEngine() throws BeansException {
        try {
            ApplicationContext context = this.getApplicationContext();
            if (context == null) {
                throw new ApplicationContextException("ApplicationContext not set");
            }
            VelocityConfig velocityConfig = (VelocityConfig)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)context, VelocityConfig.class, (boolean)true, (boolean)false);
            return velocityConfig.getVelocityEngine();
        }
        catch (NoSuchBeanDefinitionException ex) {
            throw new ApplicationContextException("Must define a single VelocityConfig bean in this web application context (may be inherited): VelocityConfigurer is the usual implementation. This bean may be given any name.", (Throwable)ex);
        }
    }

    public boolean checkResource(@Nullable Locale locale) throws Exception {
        try {
            this.template = this.getTemplate(this.getUrl());
            return true;
        }
        catch (ResourceNotFoundException ex) {
            return false;
        }
        catch (Exception ex) {
            throw new IOException("Could not load Velocity template for URL [" + this.getUrl() + "]", ex);
        }
    }

    protected void renderMergedTemplateModel(@Nonnull @NullableElements Map<String, Object> model, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) throws Exception {
        Context velocityContext = this.createVelocityContext(model, request, response);
        this.doRender(velocityContext, response);
    }

    @Nonnull
    protected Context createVelocityContext(@Nullable @NullableElements Map<String, Object> model, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) throws Exception {
        return this.createVelocityContext(model);
    }

    @Nonnull
    protected Context createVelocityContext(@Nullable @NullableElements Map<String, Object> model) throws Exception {
        return new VelocityContext(model);
    }

    protected void doRender(@Nonnull Context context, @Nonnull HttpServletResponse response) throws Exception {
        this.mergeTemplate(this.getTemplate(), context, response);
    }

    @Nonnull
    protected Template getTemplate() throws Exception {
        if (this.isCacheTemplate() && this.template != null) {
            return this.template;
        }
        return this.getTemplate(this.getUrl());
    }

    @Nonnull
    protected Template getTemplate(String name) throws Exception {
        VelocityEngine engine = this.getVelocityEngine();
        if (engine == null) {
            throw new ResourceNotFoundException("VelocityEngine not set");
        }
        return this.getEncoding() != null ? engine.getTemplate(name, this.getEncoding()) : engine.getTemplate(name);
    }

    protected void mergeTemplate(@Nonnull Template t, @Nonnull Context context, @Nonnull HttpServletResponse response) throws Exception {
        try {
            t.merge(context, (Writer)response.getWriter());
        }
        catch (MethodInvocationException ex) {
            Throwable cause = ex.getCause();
            throw new ServletException("Method invocation failed during rendering of Velocity view with name '" + this.getBeanName() + "': " + ex.getMessage() + "; reference [" + ex.getReferenceName() + "], method '" + ex.getMethodName() + "'", cause == null ? ex : cause);
        }
    }
}

