/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.security.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import net.shibboleth.idp.saml.security.impl.KeyAuthorityNodeProcessor;
import net.shibboleth.idp.saml.security.impl.MetadataPKIXValidationInformationResolver;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import net.shibboleth.shared.xml.XMLParserException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.RoleDescriptorResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.impl.NodeProcessingMetadataFilter;
import org.opensaml.saml.metadata.resolver.impl.DOMMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.PredicateRoleDescriptorResolver;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.x509.PKIXValidationInformation;
import org.opensaml.security.x509.TrustedNamesCriterion;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MetadataPKIXValidationInformationResolverTest
extends XMLObjectBaseTestCase {
    @Nonnull
    @NotEmpty
    private String protocolBlue = "PROTOCOL_BLUE";
    @Nonnull
    @NotEmpty
    private String protocolGreen = "PROTOCOL_GREEN";
    @Nonnull
    @NotEmpty
    private String fooEntityID = "http://foo.example.org/shibboleth";
    @Nonnull
    @NotEmpty
    private String barEntityID = "http://bar.example.org/shibboleth";
    @Nonnull
    private CriteriaSet criteriaSet = new CriteriaSet();

    @BeforeMethod
    protected void setUp() throws Exception {
        this.criteriaSet = new CriteriaSet();
    }

    @Test
    public void testEmpty() throws XMLParserException, ComponentInitializationException, ResolverException {
        MetadataPKIXValidationInformationResolver resolver = this.getResolver("empty-metadata-pkix.xml");
        this.criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        this.criteriaSet.add((Object)new EntityIdCriterion(this.fooEntityID));
        this.criteriaSet.add((Object)new EntityRoleCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
        this.criteriaSet.add((Object)new ProtocolCriterion(this.protocolBlue));
        Iterator iter = resolver.resolve(this.criteriaSet).iterator();
        Assert.assertFalse((boolean)iter.hasNext(), (String)"Iterator was not empty");
    }

    @Test
    public void testNames() throws ResolverException, XMLParserException, ComponentInitializationException {
        MetadataPKIXValidationInformationResolver resolver = this.getResolver("names-entities-metadata-pkix.xml");
        this.criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        this.criteriaSet.add((Object)new EntityIdCriterion(this.fooEntityID));
        this.criteriaSet.add((Object)new EntityRoleCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
        this.criteriaSet.add((Object)new ProtocolCriterion(this.protocolBlue));
        Set names = resolver.resolveTrustedNames(this.criteriaSet);
        Assert.assertNotNull((Object)names, (String)"Set of resolved trusted names was null");
        Assert.assertFalse((boolean)names.isEmpty(), (String)"Set of trusted names was empty");
        Assert.assertEquals((int)names.size(), (int)2, (String)"Set of trusted names had incorrect size");
        Assert.assertTrue((boolean)names.contains("foo.example.org"), (String)"Did't find expected name value");
        Assert.assertTrue((boolean)names.contains(this.fooEntityID), (String)"Did't find expected name value");
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        this.criteriaSet.add((Object)new EntityIdCriterion(this.fooEntityID));
        this.criteriaSet.add((Object)new EntityRoleCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
        this.criteriaSet.add((Object)new ProtocolCriterion(this.protocolGreen));
        names = resolver.resolveTrustedNames(this.criteriaSet);
        Assert.assertNotNull((Object)names, (String)"Set of resolved trusted names was null");
        Assert.assertFalse((boolean)names.isEmpty(), (String)"Set of trusted names was empty");
        Assert.assertEquals((int)names.size(), (int)3, (String)"Set of trusted names had incorrect size");
        Assert.assertTrue((boolean)names.contains("CN=foo.example.org,O=Internet2"), (String)"Did't find expected name value");
        Assert.assertTrue((boolean)names.contains("idp.example.org"), (String)"Did't find expected name value");
        Assert.assertTrue((boolean)names.contains(this.fooEntityID), (String)"Did't find expected name value");
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        this.criteriaSet.add((Object)new EntityIdCriterion(this.barEntityID));
        this.criteriaSet.add((Object)new EntityRoleCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
        this.criteriaSet.add((Object)new ProtocolCriterion(this.protocolBlue));
        names = resolver.resolveTrustedNames(this.criteriaSet);
        Assert.assertNotNull((Object)names, (String)"Set of resolved trusted names was null");
        Assert.assertFalse((boolean)names.isEmpty(), (String)"Set of trusted names was empty");
        Assert.assertEquals((int)names.size(), (int)1, (String)"Set of trusted names had incorrect size");
        Assert.assertTrue((boolean)names.contains(this.barEntityID), (String)"Did't find expected name value");
        HashSet<String> dynamicNames = new HashSet<String>(Arrays.asList("foo", "bar"));
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        this.criteriaSet.add((Object)new EntityIdCriterion(this.fooEntityID));
        this.criteriaSet.add((Object)new EntityRoleCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
        this.criteriaSet.add((Object)new ProtocolCriterion(this.protocolBlue));
        this.criteriaSet.add((Object)new TrustedNamesCriterion(dynamicNames));
        names = resolver.resolveTrustedNames(this.criteriaSet);
        Assert.assertNotNull((Object)names, (String)"Set of resolved trusted names was null");
        Assert.assertFalse((boolean)names.isEmpty(), (String)"Set of trusted names was empty");
        Assert.assertEquals((int)names.size(), (int)4, (String)"Set of trusted names had incorrect size");
        Assert.assertTrue((boolean)names.contains("foo.example.org"), (String)"Did't find expected name value");
        Assert.assertTrue((boolean)names.contains(this.fooEntityID), (String)"Did't find expected name value");
        Assert.assertTrue((boolean)names.containsAll(dynamicNames), (String)"Did't find expected name value");
    }

    @Test
    public void testNonExistentEntityID() throws ResolverException, XMLParserException, ComponentInitializationException {
        MetadataPKIXValidationInformationResolver resolver = this.getResolver("oneset-entities-metadata-pkix.xml");
        this.criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        this.criteriaSet.add((Object)new EntityIdCriterion("http://doesnt.exist.example.org/shibboleth"));
        this.criteriaSet.add((Object)new EntityRoleCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
        this.criteriaSet.add((Object)new ProtocolCriterion(this.protocolBlue));
        Iterator iter = resolver.resolve(this.criteriaSet).iterator();
        Assert.assertFalse((boolean)iter.hasNext(), (String)"Iterator was not empty");
    }

    @Test
    public void testOneSetOnEntitiesDescriptor() throws ResolverException, XMLParserException, ComponentInitializationException {
        MetadataPKIXValidationInformationResolver resolver = this.getResolver("oneset-entities-metadata-pkix.xml");
        this.criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        this.criteriaSet.add((Object)new EntityIdCriterion(this.fooEntityID));
        this.criteriaSet.add((Object)new EntityRoleCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
        this.criteriaSet.add((Object)new ProtocolCriterion(this.protocolBlue));
        Iterator iter = resolver.resolve(this.criteriaSet).iterator();
        PKIXValidationInformation infoSet = null;
        Assert.assertTrue((boolean)iter.hasNext(), (String)"Iterator was empty");
        infoSet = (PKIXValidationInformation)iter.next();
        assert (infoSet != null);
        Collection certs = infoSet.getCertificates();
        assert (certs != null);
        Collection crls = infoSet.getCRLs();
        assert (crls != null);
        Assert.assertEquals((int)certs.size(), (int)3, (String)"Incorrect number of certificates");
        Assert.assertEquals((int)crls.size(), (int)1, (String)"Incorrect number of CRL's");
        Assert.assertEquals((Integer)infoSet.getVerificationDepth(), (Integer)5, (String)"Incorrect VerifyDepth");
        Assert.assertFalse((boolean)iter.hasNext(), (String)"Iterator was not empty");
    }

    @Test
    public void testNoVerifyDepth() throws ResolverException, XMLParserException, ComponentInitializationException {
        MetadataPKIXValidationInformationResolver resolver = this.getResolver("nodepth-entities-metadata-pkix.xml");
        this.criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        this.criteriaSet.add((Object)new EntityIdCriterion(this.fooEntityID));
        this.criteriaSet.add((Object)new EntityRoleCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
        this.criteriaSet.add((Object)new ProtocolCriterion(this.protocolBlue));
        Iterator iter = resolver.resolve(this.criteriaSet).iterator();
        PKIXValidationInformation infoSet = null;
        Assert.assertTrue((boolean)iter.hasNext(), (String)"Iterator was empty");
        infoSet = (PKIXValidationInformation)iter.next();
        Assert.assertEquals((Integer)infoSet.getVerificationDepth(), (Integer)1, (String)"Incorrect VerifyDepth");
        Assert.assertFalse((boolean)iter.hasNext(), (String)"Iterator was not empty");
    }

    @Test
    public void testOneSetOnEntitiesDescriptor3KeyInfo() throws ResolverException, XMLParserException, ComponentInitializationException {
        MetadataPKIXValidationInformationResolver resolver = this.getResolver("oneset-3keyinfo-metadata-pkix.xml");
        this.criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        this.criteriaSet.add((Object)new EntityIdCriterion(this.fooEntityID));
        this.criteriaSet.add((Object)new EntityRoleCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
        this.criteriaSet.add((Object)new ProtocolCriterion(this.protocolBlue));
        Iterator iter = resolver.resolve(this.criteriaSet).iterator();
        Assert.assertTrue((boolean)iter.hasNext(), (String)"Iterator was empty");
        PKIXValidationInformation infoSet = (PKIXValidationInformation)iter.next();
        assert (infoSet != null);
        Collection certs = infoSet.getCertificates();
        assert (certs != null);
        Collection crls = infoSet.getCRLs();
        assert (crls != null);
        Assert.assertEquals((int)certs.size(), (int)7, (String)"Incorrect number of certificates");
        Assert.assertEquals((int)crls.size(), (int)2, (String)"Incorrect number of CRL's");
        Assert.assertEquals((Integer)infoSet.getVerificationDepth(), (Integer)5, (String)"Incorrect VerifyDepth");
        Assert.assertFalse((boolean)iter.hasNext(), (String)"Iterator was not empty");
    }

    @Test
    public void testOneSetOnEntityDescriptor() throws ResolverException, XMLParserException, ComponentInitializationException {
        MetadataPKIXValidationInformationResolver resolver = this.getResolver("oneset-entity-metadata-pkix.xml");
        this.criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        this.criteriaSet.add((Object)new EntityIdCriterion(this.fooEntityID));
        this.criteriaSet.add((Object)new EntityRoleCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
        this.criteriaSet.add((Object)new ProtocolCriterion(this.protocolBlue));
        Iterator iter = resolver.resolve(this.criteriaSet).iterator();
        Assert.assertTrue((boolean)iter.hasNext(), (String)"Iterator was empty");
        PKIXValidationInformation infoSet = (PKIXValidationInformation)iter.next();
        assert (infoSet != null);
        Collection certs = infoSet.getCertificates();
        assert (certs != null);
        Collection crls = infoSet.getCRLs();
        assert (crls != null);
        Assert.assertEquals((int)certs.size(), (int)3, (String)"Incorrect number of certificates");
        Assert.assertEquals((int)crls.size(), (int)1, (String)"Incorrect number of CRL's");
        Assert.assertEquals((Integer)infoSet.getVerificationDepth(), (Integer)5, (String)"Incorrect VerifyDepth");
        Assert.assertFalse((boolean)iter.hasNext(), (String)"Iterator was not empty");
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        this.criteriaSet.add((Object)new EntityIdCriterion(this.barEntityID));
        this.criteriaSet.add((Object)new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME));
        this.criteriaSet.add((Object)new ProtocolCriterion(this.protocolBlue));
        iter = resolver.resolve(this.criteriaSet).iterator();
        Assert.assertFalse((boolean)iter.hasNext(), (String)"Iterator was not empty");
    }

    @Test
    public void testTwoSetOnEntitiesAndEntityDescriptor() throws ResolverException, XMLParserException, ComponentInitializationException {
        MetadataPKIXValidationInformationResolver resolver = this.getResolver("twoset-entity-entities-metadata-pkix.xml");
        this.criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        this.criteriaSet.add((Object)new EntityIdCriterion(this.fooEntityID));
        this.criteriaSet.add((Object)new EntityRoleCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
        this.criteriaSet.add((Object)new ProtocolCriterion(this.protocolBlue));
        Iterator iter = resolver.resolve(this.criteriaSet).iterator();
        PKIXValidationInformation infoSet = null;
        Assert.assertTrue((boolean)iter.hasNext(), (String)"Iterator was empty");
        infoSet = (PKIXValidationInformation)iter.next();
        assert (infoSet != null);
        Collection certs = infoSet.getCertificates();
        assert (certs != null);
        Collection crls = infoSet.getCRLs();
        assert (crls != null);
        Assert.assertEquals((int)certs.size(), (int)1, (String)"Incorrect number of certificates");
        Assert.assertEquals((int)crls.size(), (int)1, (String)"Incorrect number of CRL's");
        Assert.assertEquals((Integer)infoSet.getVerificationDepth(), (Integer)3, (String)"Incorrect VerifyDepth");
        Assert.assertTrue((boolean)iter.hasNext(), (String)"Iterator was empty");
        infoSet = (PKIXValidationInformation)iter.next();
        assert (infoSet != null);
        certs = infoSet.getCertificates();
        assert (certs != null);
        crls = infoSet.getCRLs();
        assert (crls != null);
        Assert.assertEquals((int)certs.size(), (int)6, (String)"Incorrect number of certificates");
        Assert.assertEquals((int)crls.size(), (int)1, (String)"Incorrect number of CRL's");
        Assert.assertEquals((Integer)infoSet.getVerificationDepth(), (Integer)5, (String)"Incorrect VerifyDepth");
        Assert.assertFalse((boolean)iter.hasNext(), (String)"Iterator was not empty");
    }

    @Test
    public void testTwoSetOn2Authorities() throws ResolverException, XMLParserException, ComponentInitializationException {
        MetadataPKIXValidationInformationResolver resolver = this.getResolver("twoset-2authorities-entities-metadata-pkix.xml");
        this.criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        this.criteriaSet.add((Object)new EntityIdCriterion(this.fooEntityID));
        this.criteriaSet.add((Object)new EntityRoleCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
        this.criteriaSet.add((Object)new ProtocolCriterion(this.protocolBlue));
        Iterator iter = resolver.resolve(this.criteriaSet).iterator();
        PKIXValidationInformation infoSet = null;
        Assert.assertTrue((boolean)iter.hasNext(), (String)"Iterator was empty");
        infoSet = (PKIXValidationInformation)iter.next();
        assert (infoSet != null);
        Collection certs = infoSet.getCertificates();
        assert (certs != null);
        Collection crls = infoSet.getCRLs();
        assert (crls != null);
        Assert.assertEquals((int)certs.size(), (int)3, (String)"Incorrect number of certificates");
        Assert.assertEquals((int)crls.size(), (int)1, (String)"Incorrect number of CRL's");
        Assert.assertEquals((Integer)infoSet.getVerificationDepth(), (Integer)5, (String)"Incorrect VerifyDepth");
        Assert.assertTrue((boolean)iter.hasNext(), (String)"Iterator was empty");
        infoSet = (PKIXValidationInformation)iter.next();
        assert (infoSet != null);
        certs = infoSet.getCertificates();
        assert (certs != null);
        crls = infoSet.getCRLs();
        assert (crls != null);
        Assert.assertEquals((int)certs.size(), (int)1, (String)"Incorrect number of certificates");
        Assert.assertEquals((int)crls.size(), (int)1, (String)"Incorrect number of CRL's");
        Assert.assertEquals((Integer)infoSet.getVerificationDepth(), (Integer)3, (String)"Incorrect VerifyDepth");
        Assert.assertFalse((boolean)iter.hasNext(), (String)"Iterator was not empty");
    }

    @Test
    public void testThreeSetOn3Authorities() throws ResolverException, XMLParserException, ComponentInitializationException {
        MetadataPKIXValidationInformationResolver resolver = this.getResolver("threeset-entity-entities-entities-metadata-pkix.xml");
        this.criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        this.criteriaSet.add((Object)new EntityIdCriterion(this.fooEntityID));
        this.criteriaSet.add((Object)new EntityRoleCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
        this.criteriaSet.add((Object)new ProtocolCriterion(this.protocolBlue));
        Iterator iter = resolver.resolve(this.criteriaSet).iterator();
        PKIXValidationInformation infoSet = null;
        Assert.assertTrue((boolean)iter.hasNext(), (String)"Iterator was empty");
        infoSet = (PKIXValidationInformation)iter.next();
        assert (infoSet != null);
        Collection certs = infoSet.getCertificates();
        assert (certs != null);
        Collection crls = infoSet.getCRLs();
        assert (crls != null);
        Assert.assertEquals((int)certs.size(), (int)1, (String)"Incorrect number of certificates");
        Assert.assertEquals((int)crls.size(), (int)1, (String)"Incorrect number of CRL's");
        Assert.assertEquals((Integer)infoSet.getVerificationDepth(), (Integer)3, (String)"Incorrect VerifyDepth");
        Assert.assertTrue((boolean)iter.hasNext(), (String)"Iterator was empty");
        infoSet = (PKIXValidationInformation)iter.next();
        assert (infoSet != null);
        certs = infoSet.getCertificates();
        assert (certs != null);
        crls = infoSet.getCRLs();
        assert (crls != null);
        Assert.assertEquals((int)certs.size(), (int)3, (String)"Incorrect number of certificates");
        Assert.assertEquals((int)crls.size(), (int)0, (String)"Incorrect number of CRL's");
        Assert.assertEquals((Integer)infoSet.getVerificationDepth(), (Integer)5, (String)"Incorrect VerifyDepth");
        Assert.assertTrue((boolean)iter.hasNext(), (String)"Iterator was empty");
        infoSet = (PKIXValidationInformation)iter.next();
        assert (infoSet != null);
        certs = infoSet.getCertificates();
        assert (certs != null);
        crls = infoSet.getCRLs();
        assert (crls != null);
        Assert.assertEquals((int)certs.size(), (int)4, (String)"Incorrect number of certificates");
        Assert.assertEquals((int)crls.size(), (int)1, (String)"Incorrect number of CRL's");
        Assert.assertEquals((Integer)infoSet.getVerificationDepth(), (Integer)5, (String)"Incorrect VerifyDepth");
        Assert.assertFalse((boolean)iter.hasNext(), (String)"Iterator was not empty");
    }

    private MetadataPKIXValidationInformationResolver getResolver(String fileName) throws XMLParserException, ComponentInitializationException {
        Document mdDoc = null;
        String mdFileName = "/net/shibboleth/idp/saml/impl/security/" + fileName;
        InputStream inputStream = MetadataPKIXValidationInformationResolverTest.class.getResourceAsStream(mdFileName);
        assert (inputStream != null);
        mdDoc = parserPool.parse(inputStream);
        Element elem = mdDoc.getDocumentElement();
        assert (elem != null);
        DOMMetadataResolver mdProvider = new DOMMetadataResolver(elem);
        ArrayList<KeyAuthorityNodeProcessor> processors = new ArrayList<KeyAuthorityNodeProcessor>();
        processors.add(new KeyAuthorityNodeProcessor());
        NodeProcessingMetadataFilter nodeFilter = new NodeProcessingMetadataFilter();
        nodeFilter.setNodeProcessors(processors);
        nodeFilter.initialize();
        mdProvider.setMetadataFilter((MetadataFilter)nodeFilter);
        mdProvider.setId("Test");
        mdProvider.initialize();
        PredicateRoleDescriptorResolver roleResolver = new PredicateRoleDescriptorResolver((MetadataResolver)mdProvider);
        roleResolver.initialize();
        MetadataPKIXValidationInformationResolver resolver = new MetadataPKIXValidationInformationResolver((RoleDescriptorResolver)roleResolver);
        resolver.initialize();
        return resolver;
    }
}

