/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.security.impl;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.shibboleth.idp.saml.security.impl.KeyAuthorityNodeProcessor;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.MetadataNodeProcessor;
import org.opensaml.saml.metadata.resolver.filter.impl.NodeProcessingMetadataFilter;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.security.x509.PKIXValidationInformation;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class KeyAuthorityNodeProcessorTest
extends XMLObjectBaseTestCase {
    private FilesystemMetadataResolver metadataProvider;
    private File mdFile;
    private NodeProcessingMetadataFilter metadataFilter;
    private ArrayList<MetadataNodeProcessor> processors;

    @BeforeMethod
    protected void setUp() throws Exception {
        URL mdURL = KeyAuthorityNodeProcessorTest.class.getResource("/net/shibboleth/idp/saml/impl/security/KeyAuthority-NodeProcessor-metadata.xml");
        this.mdFile = new File(mdURL.toURI());
        this.processors = new ArrayList();
        this.processors.add((MetadataNodeProcessor)new KeyAuthorityNodeProcessor());
        this.metadataFilter = new NodeProcessingMetadataFilter();
        assert (this.processors != null);
        this.metadataFilter.setNodeProcessors(this.processors);
        this.metadataFilter.initialize();
        assert (this.mdFile != null);
        this.metadataProvider = new FilesystemMetadataResolver(this.mdFile);
        assert (parserPool != null);
        this.metadataProvider.setParserPool(parserPool);
        this.metadataProvider.setMetadataFilter((MetadataFilter)this.metadataFilter);
        this.metadataProvider.setId("test");
        this.metadataProvider.initialize();
    }

    @Test
    public void testPKIXHierarchy() throws ResolverException {
        EntityDescriptor entityDescriptor = null;
        List pkixInfos = null;
        entityDescriptor = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("https://idp-top.example.org")}));
        assert (entityDescriptor != null);
        pkixInfos = entityDescriptor.getObjectMetadata().get(PKIXValidationInformation.class);
        Assert.assertEquals((int)pkixInfos.size(), (int)2);
        entityDescriptor = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("https://idp-sub1.example.org")}));
        assert (entityDescriptor != null);
        pkixInfos = entityDescriptor.getObjectMetadata().get(PKIXValidationInformation.class);
        Assert.assertEquals((int)pkixInfos.size(), (int)3);
        entityDescriptor = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("https://idp-sub2.example.org")}));
        assert (entityDescriptor != null);
        pkixInfos = entityDescriptor.getObjectMetadata().get(PKIXValidationInformation.class);
        Assert.assertEquals((int)pkixInfos.size(), (int)4);
        entityDescriptor = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("https://idp-sub2a.example.org")}));
        assert (entityDescriptor != null);
        pkixInfos = entityDescriptor.getObjectMetadata().get(PKIXValidationInformation.class);
        Assert.assertEquals((int)pkixInfos.size(), (int)5);
    }
}

