/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.metadata.impl;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.shibboleth.idp.saml.metadata.ACSUIInfo;
import net.shibboleth.idp.saml.metadata.IdPUIInfo;
import net.shibboleth.idp.saml.metadata.OrganizationUIInfo;
import net.shibboleth.idp.saml.metadata.impl.BaseNodeProcessorTest;
import net.shibboleth.idp.saml.metadata.impl.UIInfoNodeProcessor;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.ext.saml2mdui.UIInfo;
import org.opensaml.saml.metadata.resolver.filter.MetadataNodeProcessor;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.Organization;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.testng.Assert;
import org.testng.annotations.Test;

public final class UIInfoNodeProcessorTest
extends BaseNodeProcessorTest {
    @Test
    public void idPUIInfoTest() throws ResolverException {
        Extensions ext;
        EntityDescriptor entity = (EntityDescriptor)this.resolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new EntityIdCriterion("https://scopes.example.org")}));
        assert (entity != null);
        IDPSSODescriptor idpSSO = entity.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        Extensions extensions = ext = idpSSO != null ? idpSSO.getExtensions() : null;
        assert (ext != null);
        IdPUIInfo uiInfo = null;
        for (XMLObject x : ext.getUnknownXMLObjects()) {
            if (!(x instanceof UIInfo)) continue;
            uiInfo = (IdPUIInfo)x.getObjectMetadata().get(IdPUIInfo.class).get(0);
            break;
        }
        assert (uiInfo != null);
        Locale l = Locale.forLanguageTag("en");
        Assert.assertEquals((String)((String)uiInfo.getDisplayNames().get(l)), (String)"Display");
        Assert.assertEquals((String)((String)uiInfo.getDescriptions().get(l)), (String)"Desc");
        Assert.assertEquals((int)((List)uiInfo.getLocaleLogos().get(l)).size(), (int)1);
        Assert.assertEquals((int)uiInfo.getNonLocaleLogos().size(), (int)2);
    }

    public void acsUIInfoTest() throws ResolverException {
        EntityDescriptor entity = (EntityDescriptor)this.resolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new EntityIdCriterion("https://sp.example.org")}));
        assert (entity != null);
        SPSSODescriptor role = entity.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        assert (role != null);
        AssertionConsumerService acs = (AssertionConsumerService)role.getAssertionConsumerServices().get(0);
        ACSUIInfo uiInfo = (ACSUIInfo)acs.getObjectMetadata().get(ACSUIInfo.class).get(0);
        Locale l = Locale.forLanguageTag("en");
        Assert.assertEquals((String)((String)uiInfo.getServiceNames().get(l)), (String)"ServiceName");
        Assert.assertEquals((String)((String)uiInfo.getServiceDescriptions().get(l)), (String)"ServiceDesc");
    }

    public void organizationInfoTest() throws ResolverException {
        EntityDescriptor entity = (EntityDescriptor)this.resolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new EntityIdCriterion("https://sp.example.org")}));
        assert (entity != null);
        Organization org = entity.getOrganization();
        assert (org != null);
        OrganizationUIInfo info = (OrganizationUIInfo)org.getObjectMetadata().get(OrganizationUIInfo.class).get(0);
        Assert.assertEquals((int)info.getOrganizationNames().size(), (int)2);
        Assert.assertEquals((String)((String)info.getOrganizationNames().get(Locale.forLanguageTag("en"))), (String)"org");
        Assert.assertEquals((int)info.getOrganizationDisplayNames().size(), (int)1);
        Assert.assertEquals((int)info.getOrganizationUrls().size(), (int)1);
    }

    @Override
    @Nonnull
    protected MetadataNodeProcessor getProcessor() {
        return new UIInfoNodeProcessor();
    }
}

