/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.metadata.impl;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.MetadataNodeProcessor;
import org.opensaml.saml.metadata.resolver.filter.impl.NodeProcessingMetadataFilter;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolver;
import org.testng.annotations.BeforeClass;

public abstract class BaseNodeProcessorTest
extends XMLObjectBaseTestCase {
    protected MetadataResolver resolver;

    @BeforeClass
    public void getMetadataResolver() throws URISyntaxException, ComponentInitializationException, ResolverException {
        URL mdURL = BaseNodeProcessorTest.class.getResource("/net/shibboleth/idp/saml/impl/metadata/NodeProcessor-metadata.xml");
        File mdFile = new File(mdURL.toURI());
        List processors = CollectionSupport.listOf((Object)this.getProcessor());
        NodeProcessingMetadataFilter metadataFilter = new NodeProcessingMetadataFilter();
        metadataFilter.setNodeProcessors(processors);
        metadataFilter.initialize();
        FilesystemMetadataResolver fileResolver = new FilesystemMetadataResolver(mdFile);
        assert (parserPool != null);
        fileResolver.setParserPool(parserPool);
        fileResolver.setMetadataFilter((MetadataFilter)metadataFilter);
        fileResolver.setId("test");
        fileResolver.initialize();
        this.resolver = fileResolver;
    }

    @Nonnull
    protected abstract MetadataNodeProcessor getProcessor();
}

