/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ws_cleanup;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.ws_cleanup.Cleanup;
import hudson.plugins.ws_cleanup.DisableDeferredWipeoutNodeProperty;
import hudson.plugins.ws_cleanup.Pattern;
import hudson.plugins.ws_cleanup.Wipeout;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import java.io.IOException;
import java.util.List;

abstract class RemoteCleaner {
    RemoteCleaner() {
    }

    static RemoteCleaner get(List<Pattern> patterns, boolean deleteDirs, String externalDelete, TaskListener listener, Run<?, ?> build, boolean disableDeferredWipeout) {
        boolean wipeout = !(patterns != null && !patterns.isEmpty() || externalDelete != null && !externalDelete.trim().isEmpty() || disableDeferredWipeout);
        Node node = null;
        if (build instanceof AbstractBuild) {
            node = ((AbstractBuild)build).getBuiltOn();
        }
        if (disableDeferredWipeout) {
            listener.getLogger().append("[WS-CLEANUP] Deferred wipeout is disabled by the job configuration...\n");
        }
        if (wipeout && node != null) {
            boolean bl = wipeout = node.getNodeProperties().get(DisableDeferredWipeoutNodeProperty.class) == null;
            if (!wipeout) {
                listener.getLogger().append("[WS-CLEANUP] Deferred wipeout is disabled by the node property...\n");
            }
        }
        if (wipeout) {
            listener.getLogger().append("[WS-CLEANUP] Deferred wipeout is used...\n");
            return Wipeout.getInstance();
        }
        EnvironmentVariablesNodeProperty properties = null;
        if (node != null) {
            properties = (EnvironmentVariablesNodeProperty)node.getNodeProperties().get(EnvironmentVariablesNodeProperty.class);
        }
        return new Cleanup(patterns, deleteDirs, properties, externalDelete, listener);
    }

    protected abstract void perform(FilePath var1) throws IOException, InterruptedException;
}

