/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.job.properties;

import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.triggers.TimerTrigger;
import hudson.triggers.Trigger;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.htmlunit.HttpMethod;
import org.htmlunit.WebRequest;
import org.htmlunit.util.NameValuePair;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.properties.MockTrigger;
import org.jenkinsci.plugins.workflow.job.properties.PipelineTriggersJobProperty;
import org.jenkinsci.plugins.workflow.job.properties.QueryingMockTrigger;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.BuildWatcher;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.recipes.LocalData;

public class PipelineTriggersJobPropertyTest {
    @ClassRule
    public static BuildWatcher buildWatcher = new BuildWatcher();
    @Rule
    public JenkinsRule r = new JenkinsRule();

    @After
    public void resetStartsAndStops() {
        MockTrigger.startsAndStops = new ArrayList<Boolean>();
        QueryingMockTrigger.startsAndStops = new ArrayList<Boolean>();
    }

    @Test
    public void loadCallsStartFalse() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        MockTrigger t = new MockTrigger();
        p.addTrigger((Trigger)t);
        p.save();
        p = (WorkflowJob)Items.load((ItemGroup)p.getParent(), (File)p.getRootDir());
        t = (MockTrigger)((Object)p.getTriggers().get(t.getDescriptor()));
        Assert.assertNotNull((Object)((Object)t));
        Assert.assertEquals((Object)"[null, false, null, false]", (Object)MockTrigger.startsAndStops.toString());
        Boolean currentStatus = t.currentStatus();
        Assert.assertNotNull((Object)currentStatus);
        Assert.assertFalse((boolean)currentStatus);
    }

    @Test
    public void submitCallsStartTrue() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        MockTrigger t = new MockTrigger();
        p.addTrigger((Trigger)t);
        p.save();
        p = (WorkflowJob)this.r.configRoundtrip((Item)p);
        t = (MockTrigger)((Object)p.getTriggers().get(t.getDescriptor()));
        Assert.assertNotNull((Object)((Object)t));
        Assert.assertEquals((Object)"[null, false, null, true, null, false]", (Object)MockTrigger.startsAndStops.toString());
        Boolean currentStatus = t.currentStatus();
        Assert.assertNotNull((Object)currentStatus);
        Assert.assertFalse((boolean)currentStatus);
    }

    @Test
    public void previousTriggerStopped() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        MockTrigger t = new MockTrigger();
        p.addTrigger((Trigger)t);
        p.save();
        MockTrigger t2 = new MockTrigger();
        p.addTrigger((Trigger)t2);
        p.save();
        Assert.assertFalse((boolean)t.isStarted);
        Assert.assertTrue((boolean)t2.isStarted);
    }

    @LocalData
    @Test
    public void triggerMigration() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.getItemByFullName("p", WorkflowJob.class);
        Assert.assertNotNull((Object)p);
        PipelineTriggersJobProperty triggerProp = (PipelineTriggersJobProperty)p.getProperty(PipelineTriggersJobProperty.class);
        Assert.assertNotNull((Object)triggerProp);
        Assert.assertEquals((long)2L, (long)triggerProp.getTriggers().size());
        Assert.assertEquals((long)2L, (long)p.getTriggers().size());
        TimerTrigger timerFromProp = this.getTriggerFromList(TimerTrigger.class, triggerProp.getTriggers());
        Assert.assertNotNull((Object)timerFromProp);
        Assert.assertEquals(TimerTrigger.class, timerFromProp.getClass());
        Trigger timerFromJob = (Trigger)p.getTriggers().get(timerFromProp.getDescriptor());
        Assert.assertEquals((Object)timerFromProp, (Object)timerFromJob);
        MockTrigger mockFromProp = this.getTriggerFromList(MockTrigger.class, triggerProp.getTriggers());
        Assert.assertNotNull((Object)((Object)mockFromProp));
        Assert.assertEquals(MockTrigger.class, ((Object)((Object)mockFromProp)).getClass());
        Trigger mockFromJob = (Trigger)p.getTriggers().get(mockFromProp.getDescriptor());
        Assert.assertEquals((Object)((Object)mockFromProp), (Object)mockFromJob);
        Assert.assertNotNull((Object)mockFromProp.currentStatus());
        Assert.assertEquals((Object)"[null, false, null, false]", (Object)MockTrigger.startsAndStops.toString());
        TimerTrigger newTimerTrigger = new TimerTrigger("@hourly");
        p.addTrigger((Trigger)newTimerTrigger);
        Assert.assertEquals((long)2L, (long)p.getTriggers().size());
        Assert.assertNotNull(p.getTriggers().get(mockFromJob.getDescriptor()));
        Trigger newTimerFromJob = (Trigger)p.getTriggers().get(newTimerTrigger.getDescriptor());
        Assert.assertEquals((Object)newTimerTrigger.getSpec(), (Object)newTimerFromJob.getSpec());
    }

    @Test
    public void configRoundTrip() throws Exception {
        WorkflowJob defaultCase = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "defaultCase");
        Assert.assertTrue((boolean)defaultCase.getTriggers().isEmpty());
        Assert.assertNull((Object)defaultCase.getProperty(PipelineTriggersJobProperty.class));
        WorkflowJob roundTripDefault = (WorkflowJob)this.r.configRoundtrip((Item)defaultCase);
        Assert.assertTrue((boolean)roundTripDefault.getTriggers().isEmpty());
        Assert.assertNull((Object)defaultCase.getProperty(PipelineTriggersJobProperty.class));
        WorkflowJob withTriggerCase = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "withTriggerCase");
        withTriggerCase.addTrigger((Trigger)new MockTrigger());
        Assert.assertEquals((long)1L, (long)withTriggerCase.getTriggers().size());
        ArrayList origTriggers = new ArrayList(withTriggerCase.getTriggers().values());
        Assert.assertEquals(MockTrigger.class, ((Trigger)origTriggers.get(0)).getClass());
        WorkflowJob roundTripWithTrigger = (WorkflowJob)this.r.configRoundtrip((Item)withTriggerCase);
        Assert.assertEquals((long)1L, (long)roundTripWithTrigger.getTriggers().size());
        ArrayList modTriggers = new ArrayList(roundTripWithTrigger.getTriggers().values());
        Assert.assertEquals(MockTrigger.class, ((Trigger)modTriggers.get(0)).getClass());
        Assert.assertNotNull((Object)((MockTrigger)((Object)modTriggers.get(0))).currentStatus());
        Assert.assertEquals((Object)"[null, false, null, true, null, false]", (Object)MockTrigger.startsAndStops.toString());
    }

    @Test
    public void triggerPresentDuringStart() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "triggerPresent");
        Assert.assertNull((Object)((Object)this.getTriggerFromList(QueryingMockTrigger.class, p.getTriggersJobProperty().getTriggers())));
        JenkinsRule.WebClient wc = this.r.createWebClient();
        String newConfig = IOUtils.toString((InputStream)PipelineTriggersJobPropertyTest.class.getResourceAsStream("/org/jenkinsci/plugins/workflow/job/properties/PipelineTriggersJobPropertyTest/triggerPresentDuringStart.json"), (Charset)StandardCharsets.UTF_8);
        WebRequest request = new WebRequest(new URL(p.getAbsoluteUrl() + "configSubmit"), HttpMethod.POST);
        wc.addCrumb(request);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(request.getRequestParameters());
        params.add(new NameValuePair("json", newConfig));
        request.setRequestParameters(params);
        wc.getPage(request);
        QueryingMockTrigger t = this.getTriggerFromList(QueryingMockTrigger.class, p.getTriggersJobProperty().getTriggers());
        Assert.assertNotNull((Object)((Object)t));
        Assert.assertTrue((boolean)t.isStarted);
        Assert.assertTrue((boolean)t.foundSelf);
    }

    private <T extends Trigger<?>> T getTriggerFromList(Class<T> clazz, List<Trigger<?>> triggers) {
        for (Trigger<?> t : triggers) {
            if (!clazz.isInstance(t)) continue;
            return (T)((Trigger)clazz.cast(t));
        }
        return null;
    }
}

