/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.job;

import hudson.model.Job;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.junit.AssumptionViolatedException;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.BuildWatcher;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.LoggerRule;
import org.jvnet.hudson.test.MemoryAssert;

public class MemoryCleanupTest {
    @ClassRule
    public static BuildWatcher buildWatcher = new BuildWatcher();
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @Rule
    public LoggerRule logging = new LoggerRule();

    @Test
    public void cleanup() throws Exception {
        this.logging.record("", Level.INFO).capture(256);
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("", true));
        WorkflowRun b1 = (WorkflowRun)this.r.buildAndAssertSuccess((Job)p);
        WeakReference<WorkflowRun> b1r = new WeakReference<WorkflowRun>(b1);
        b1.delete();
        b1 = null;
        this.r.jenkins.getQueue().clearLeftItems();
        try {
            MemoryAssert.assertGC(b1r, (boolean)false);
        }
        catch (NoClassDefFoundError x) {
            if ("org/netbeans/insane/hook/MakeAccessible".equals(x.getMessage())) {
                throw new AssumptionViolatedException("TODO https://github.com/jenkinsci/bom/issues/1551", (Throwable)x);
            }
            throw x;
        }
    }
}

