/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.job;

import hudson.cli.CLICommandInvoker;
import hudson.model.Job;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.BuildWatcher;
import org.jvnet.hudson.test.JenkinsRule;

public class CLITest {
    @ClassRule
    public static BuildWatcher buildWatcher = new BuildWatcher();
    @Rule
    public JenkinsRule r = new JenkinsRule();

    @Test
    public void deleteBuilds() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("", true));
        for (int i = 0; i < 5; ++i) {
            this.r.buildAndAssertSuccess((Job)p);
        }
        MatcherAssert.assertThat((Object)new CLICommandInvoker(this.r, "delete-builds").invokeWithArgs(new String[]{"p", "2-4"}), (Matcher)CLICommandInvoker.Matcher.succeeded());
        Assert.assertEquals((Object)"[5, 1]", (Object)p.getBuildsAsMap().keySet().toString());
    }

    @Test
    public void listChanges() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {def s = new org.jvnet.hudson.test.FakeChangeLogSCM(); s.addChange().withAuthor('alice').withMsg('hello'); checkout s}", false));
        this.r.buildAndAssertSuccess((Job)p);
        CLICommandInvoker.Result res = new CLICommandInvoker(this.r, "list-changes").invokeWithArgs(new String[]{"p", "1"});
        MatcherAssert.assertThat((Object)res, (Matcher)CLICommandInvoker.Matcher.succeeded());
        MatcherAssert.assertThat((Object)res.stdout(), (Matcher)Matchers.containsString((String)"alice\thello"));
    }

    @Test
    public void console() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'this is what I said'", true));
        this.r.buildAndAssertSuccess((Job)p);
        CLICommandInvoker.Result res = new CLICommandInvoker(this.r, "console").invokeWithArgs(new String[]{"p"});
        MatcherAssert.assertThat((Object)res, (Matcher)CLICommandInvoker.Matcher.succeeded());
        MatcherAssert.assertThat((Object)res.stdout(), (Matcher)Matchers.containsString((String)"this is what I said"));
    }

    @Test
    public void reload() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'first version'", true));
        this.r.assertLogContains("first version", this.r.buildAndAssertSuccess((Job)p));
        File configXml = new File(p.getRootDir(), "config.xml");
        FileUtils.write((File)configXml, (CharSequence)FileUtils.readFileToString((File)configXml, (Charset)StandardCharsets.UTF_8).replace("first version", "second version"), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)new CLICommandInvoker(this.r, "reload-job").invokeWithArgs(new String[]{"p"}), (Matcher)CLICommandInvoker.Matcher.succeededSilently());
        this.r.assertLogContains("second version", this.r.buildAndAssertSuccess((Job)p));
        CLICommandInvoker.Result res = new CLICommandInvoker(this.r, "reload-job").invokeWithArgs(new String[]{"q"});
        MatcherAssert.assertThat((Object)res, (Matcher)CLICommandInvoker.Matcher.failedWith((long)3L));
        MatcherAssert.assertThat((Object)res.stderr(), (Matcher)Matchers.containsString((String)"No such item \u2018q\u2019 exists. Perhaps you meant \u2018p\u2019?"));
    }

    @Test
    public void setBuildDescriptionAndDisplayName() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("", true));
        WorkflowRun b = (WorkflowRun)this.r.buildAndAssertSuccess((Job)p);
        MatcherAssert.assertThat((Object)new CLICommandInvoker(this.r, "set-build-description").invokeWithArgs(new String[]{"p", "1", "the desc"}), (Matcher)CLICommandInvoker.Matcher.succeededSilently());
        Assert.assertEquals((Object)"the desc", (Object)b.getDescription());
        MatcherAssert.assertThat((Object)new CLICommandInvoker(this.r, "set-build-display-name").invokeWithArgs(new String[]{"p", "1", "the name"}), (Matcher)CLICommandInvoker.Matcher.succeededSilently());
        Assert.assertEquals((Object)"the name", (Object)b.getDisplayName());
    }
}

