// CHECKSTYLE:OFF

package org.jenkinsci.plugins.workflow.job;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code WorkflowJob.DisplayName}: {@code Pipeline}.
     * 
     * @return
     *     {@code Pipeline}
     */
    public static String WorkflowJob_DisplayName() {
        return holder.format("WorkflowJob.DisplayName");
    }

    /**
     * Key {@code WorkflowJob.DisplayName}: {@code Pipeline}.
     * 
     * @return
     *     {@code Pipeline}
     */
    public static Localizable _WorkflowJob_DisplayName() {
        return new Localizable(holder, "WorkflowJob.DisplayName");
    }

    /**
     * Key {@code WorkflowJob.Description}: {@code Orchestrates long-running

     * activities that can span multiple build agents. Suitable for building

     * pipelines (formerly known as workflows) and/or organizing complex

     * activities that do not easily fit in free-style job type.}.
     * 
     * @return
     *     {@code Orchestrates long-running activities that can span multiple

     *     build agents. Suitable for building pipelines (formerly known as

     *     workflows) and/or organizing complex activities that do not easily fit

     *     in free-style job type.}
     */
    public static String WorkflowJob_Description() {
        return holder.format("WorkflowJob.Description");
    }

    /**
     * Key {@code WorkflowJob.Description}: {@code Orchestrates long-running

     * activities that can span multiple build agents. Suitable for building

     * pipelines (formerly known as workflows) and/or organizing complex

     * activities that do not easily fit in free-style job type.}.
     * 
     * @return
     *     {@code Orchestrates long-running activities that can span multiple

     *     build agents. Suitable for building pipelines (formerly known as

     *     workflows) and/or organizing complex activities that do not easily fit

     *     in free-style job type.}
     */
    public static Localizable _WorkflowJob_Description() {
        return new Localizable(holder, "WorkflowJob.Description");
    }

}
