/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.job.properties;

import hudson.model.Item;
import hudson.model.Job;
import hudson.model.JobProperty;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDurabilityHint;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.properties.DurabilityHintJobProperty;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.BuildWatcher;
import org.jvnet.hudson.test.JenkinsRule;

public class DurabilityHintJobPropertyTest {
    @ClassRule
    public static BuildWatcher buildWatcher = new BuildWatcher();
    @Rule
    public JenkinsRule r = new JenkinsRule();

    @Test
    public void configRoundTripAndRun() throws Exception {
        WorkflowJob defaultCase = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "testCase");
        defaultCase.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'cheese is delicious'", true));
        Assert.assertNull((Object)defaultCase.getProperty(DurabilityHintJobProperty.class));
        for (FlowDurabilityHint hint : FlowDurabilityHint.values()) {
            try {
                defaultCase.addProperty((JobProperty)new DurabilityHintJobProperty(hint));
                Assert.assertEquals((Object)hint, (Object)((DurabilityHintJobProperty)defaultCase.getProperty(DurabilityHintJobProperty.class)).getHint());
                this.r.configRoundtrip((Item)defaultCase);
                Assert.assertEquals((Object)hint, (Object)((DurabilityHintJobProperty)defaultCase.getProperty(DurabilityHintJobProperty.class)).getHint());
                this.r.buildAndAssertSuccess((Job)defaultCase);
                Assert.assertEquals((Object)hint, (Object)defaultCase.getLastBuild().getExecution().getDurabilityHint());
                defaultCase.removeProperty(DurabilityHintJobProperty.class);
                Assert.assertNull((Object)defaultCase.getProperty(DurabilityHintJobProperty.class));
            }
            catch (Exception ex) {
                throw new Exception("Error with FlowDurabilityHint " + String.valueOf(hint), ex);
            }
        }
    }
}

