// CHECKSTYLE:OFF

package org.jenkinsci.plugins.workflow.job.properties;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code build_triggers}: {@code Build triggers}.
     * 
     * @return
     *     {@code Build triggers}
     */
    public static String build_triggers() {
        return holder.format("build_triggers");
    }

    /**
     * Key {@code build_triggers}: {@code Build triggers}.
     * 
     * @return
     *     {@code Build triggers}
     */
    public static Localizable _build_triggers() {
        return new Localizable(holder, "build_triggers");
    }

    /**
     * Key {@code do_not_allow_resume_if_master_restarts}: {@code Do not
     * allow the pipeline to resume if the controller restarts}.
     * 
     * @return
     *     {@code Do not allow the pipeline to resume if the controller restarts}
     */
    public static String do_not_allow_resume_if_master_restarts() {
        return holder.format("do_not_allow_resume_if_master_restarts");
    }

    /**
     * Key {@code do_not_allow_resume_if_master_restarts}: {@code Do not
     * allow the pipeline to resume if the controller restarts}.
     * 
     * @return
     *     {@code Do not allow the pipeline to resume if the controller restarts}
     */
    public static Localizable _do_not_allow_resume_if_master_restarts() {
        return new Localizable(holder, "do_not_allow_resume_if_master_restarts");
    }

    /**
     * Key {@code do_not_allow_concurrent_builds}: {@code Do not allow
     * concurrent builds}.
     * 
     * @return
     *     {@code Do not allow concurrent builds}
     */
    public static String do_not_allow_concurrent_builds() {
        return holder.format("do_not_allow_concurrent_builds");
    }

    /**
     * Key {@code do_not_allow_concurrent_builds}: {@code Do not allow
     * concurrent builds}.
     * 
     * @return
     *     {@code Do not allow concurrent builds}
     */
    public static Localizable _do_not_allow_concurrent_builds() {
        return new Localizable(holder, "do_not_allow_concurrent_builds");
    }

    /**
     * Key {@code speed_durability_override}: {@code Pipeline
     * speed/durability override}.
     * 
     * @return
     *     {@code Pipeline speed/durability override}
     */
    public static String speed_durability_override() {
        return holder.format("speed_durability_override");
    }

    /**
     * Key {@code speed_durability_override}: {@code Pipeline
     * speed/durability override}.
     * 
     * @return
     *     {@code Pipeline speed/durability override}
     */
    public static Localizable _speed_durability_override() {
        return new Localizable(holder, "speed_durability_override");
    }

}
