/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.job.console;

import hudson.model.Job;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.BuildWatcher;
import org.jvnet.hudson.test.JenkinsRule;

public class NewNodeConsoleNoteTest {
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @ClassRule
    public static BuildWatcher buildWatcher = new BuildWatcher();

    @Test
    public void labels() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("parallel first: {}, second: {stage('\"full\" details') {}}", true));
        WorkflowRun b = (WorkflowRun)this.r.buildAndAssertSuccess((Job)p);
        String html = this.r.createWebClient().goTo(b.getUrl() + "console").getWebResponse().getContentAsString();
        MatcherAssert.assertThat((Object)html, (Matcher)Matchers.containsString((String)"<span class=\"pipeline-new-node\" nodeId=\"3\" startId=\"3\" enclosingId=\"2\">[Pipeline] parallel"));
        MatcherAssert.assertThat((Object)html, (Matcher)Matchers.containsString((String)"<span class=\"pipeline-new-node\" nodeId=\"5\" startId=\"5\" enclosingId=\"3\" label=\"Branch: first\">[Pipeline] {"));
        MatcherAssert.assertThat((Object)html, (Matcher)Matchers.containsString((String)"<span class=\"pipeline-new-node\" nodeId=\"6\" startId=\"6\" enclosingId=\"3\" label=\"Branch: second\">[Pipeline] {"));
        MatcherAssert.assertThat((Object)html, (Matcher)Matchers.containsString((String)"<span class=\"pipeline-new-node\" nodeId=\"9\" startId=\"9\" enclosingId=\"8\" label=\"&quot;full&quot; details\">[Pipeline] {"));
        MatcherAssert.assertThat((Object)html, (Matcher)Matchers.containsString((String)"<span class=\"pipeline-new-node\" nodeId=\"13\" startId=\"3\">[Pipeline] // parallel"));
    }
}

