/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.job;

import com.google.common.util.concurrent.ListenableFuture;
import hudson.model.Action;
import hudson.model.JobProperty;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.List;
import java.util.Stack;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDurabilityHint;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionList;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowStartNode;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.job.properties.DurabilityHintJobProperty;
import org.jenkinsci.plugins.workflow.support.steps.input.InputAction;
import org.jenkinsci.plugins.workflow.support.steps.input.InputStepExecution;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.BuildWatcher;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.RestartableJenkinsRule;

public class CpsPersistenceTest {
    @ClassRule
    public static BuildWatcher buildWatcher = new BuildWatcher();
    @Rule
    public RestartableJenkinsRule story = new RestartableJenkinsRule();
    private static final String DEFAULT_JOBNAME = "testJob";

    private static boolean getCpsDoneFlag(CpsFlowExecution exec) throws Exception {
        Field doneField = exec.getClass().getDeclaredField("done");
        doneField.setAccessible(true);
        return doneField.getBoolean(exec);
    }

    private static Stack<BlockStartNode> getCpsBlockStartNodes(CpsFlowExecution exec) throws Exception {
        Field startField = exec.getClass().getDeclaredField("startNodes");
        startField.setAccessible(true);
        Object ob = startField.get(exec);
        if (ob instanceof Stack) {
            Stack result = (Stack)ob;
            return result;
        }
        return null;
    }

    private static void assertCompletedCleanly(WorkflowRun run) throws Exception {
        if (run.isBuilding()) {
            System.out.println("Run initially building, going to wait a second to see if it finishes, run=" + String.valueOf(run));
            Thread.sleep(1000L);
        }
        Assert.assertFalse((boolean)run.isBuilding());
        Assert.assertNotNull((Object)run.getResult());
        FlowExecution fe = run.getExecution();
        FlowExecutionList.get().forEach(f -> {
            if (fe != null && f == fe) {
                Assert.fail((String)"FlowExecution still in FlowExecutionList!");
            }
        });
        Assert.assertTrue((String)"Queue not empty after completion!", (boolean)Queue.getInstance().isEmpty());
        if (fe instanceof CpsFlowExecution) {
            CpsFlowExecution cpsExec = (CpsFlowExecution)fe;
            Assert.assertTrue((boolean)cpsExec.isComplete());
            Assert.assertEquals((Object)Boolean.TRUE, (Object)CpsPersistenceTest.getCpsDoneFlag(cpsExec));
            Assert.assertEquals((long)1L, (long)cpsExec.getCurrentHeads().size());
            Assert.assertTrue((boolean)cpsExec.isComplete());
            Assert.assertTrue((boolean)(cpsExec.getCurrentHeads().get(0) instanceof FlowEndNode));
            Stack<BlockStartNode> starts = CpsPersistenceTest.getCpsBlockStartNodes(cpsExec);
            Assert.assertTrue((starts == null || starts.isEmpty() ? 1 : 0) != 0);
            Thread.sleep(1000L);
            Assert.assertFalse((boolean)cpsExec.blocksRestart());
        } else {
            System.out.println("WARNING: no FlowExecutionForBuild");
        }
    }

    private static WorkflowRun runBasicPauseOnInput(JenkinsRule j, String jobName, int[] jobIdNumber, FlowDurabilityHint durabilityHint) throws Exception {
        WorkflowJob job = (WorkflowJob)j.jenkins.createProject(WorkflowJob.class, jobName);
        job.setDefinition((FlowDefinition)new CpsFlowDefinition("input 'pause'", true));
        job.addProperty((JobProperty)new DurabilityHintJobProperty(durabilityHint));
        WorkflowRun run = (WorkflowRun)job.scheduleBuild2(0, new Action[0]).getStartCondition().get();
        ListenableFuture listener = run.getExecutionPromise();
        FlowExecution exec = (FlowExecution)listener.get();
        while (exec.getCurrentHeads().isEmpty() || exec.getCurrentHeads().get(0) instanceof FlowStartNode) {
            System.out.println("Waiting for input step to begin");
            Thread.sleep(50L);
        }
        while (run.getAction(InputAction.class) == null) {
            System.out.println("Waiting for input action to get attached to run");
            Thread.sleep(50L);
        }
        Thread.sleep(100L);
        if (durabilityHint != FlowDurabilityHint.PERFORMANCE_OPTIMIZED) {
            CpsFlowExecution execution = (CpsFlowExecution)run.getExecution();
            Method m = execution.getClass().getDeclaredMethod("getProgramDataFile", new Class[0]);
            m.setAccessible(true);
            File f = (File)m.invoke((Object)execution, new Object[0]);
            while (!Files.exists(f.toPath(), new LinkOption[0])) {
                System.out.println("Waiting for program to be persisted");
                Thread.sleep(50L);
            }
        }
        jobIdNumber[0] = run.getNumber();
        return run;
    }

    private static WorkflowRun runBasicPauseOnInput(JenkinsRule j, String jobName, int[] jobIdNumber) throws Exception {
        return CpsPersistenceTest.runBasicPauseOnInput(j, jobName, jobIdNumber, FlowDurabilityHint.MAX_SURVIVABILITY);
    }

    private static InputStepExecution getInputStepExecution(WorkflowRun run, String inputMessage) throws Exception {
        InputAction ia = (InputAction)run.getAction(InputAction.class);
        List execList = ia.getExecutions();
        return execList.stream().filter(e -> inputMessage.equals(e.getInput().getMessage())).findFirst().orElse(null);
    }

    @Test
    public void completedExecutionButRunIncomplete() {
        int[] build = new int[1];
        this.story.thenWithHardShutdown(j -> {
            WorkflowRun run = CpsPersistenceTest.runBasicPauseOnInput(j, DEFAULT_JOBNAME, build);
            InputStepExecution exec = CpsPersistenceTest.getInputStepExecution(run, "pause");
            exec.doProceedEmpty();
            j.waitForCompletion((Run)run);
            Field completedField = run.getClass().getDeclaredField("completed");
            completedField.setAccessible(true);
            completedField.set(run, false);
            Field resultField = Run.class.getDeclaredField("result");
            resultField.setAccessible(true);
            resultField.set(run, null);
            run.save();
        });
        this.story.then(j -> {
            WorkflowJob r = (WorkflowJob)j.jenkins.getItemByFullName(DEFAULT_JOBNAME, WorkflowJob.class);
            WorkflowRun run = r.getBuildByNumber(build[0]);
            CpsPersistenceTest.assertCompletedCleanly(run);
            Assert.assertEquals((Object)Result.SUCCESS, (Object)run.getResult());
        });
        this.story.then(j -> {
            WorkflowJob r = (WorkflowJob)j.jenkins.getItemByFullName(DEFAULT_JOBNAME, WorkflowJob.class);
            WorkflowRun run = r.getBuildByNumber(build[0]);
            CpsPersistenceTest.assertCompletedCleanly(run);
            Assert.assertEquals((Object)Result.SUCCESS, (Object)run.getResult());
        });
    }
}

