/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.job;

import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Result;
import hudson.tasks.BuildTrigger;
import hudson.util.FormValidation;
import java.util.Collections;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.BuildWatcher;
import org.jvnet.hudson.test.JenkinsRule;

public class BuildTriggerTest {
    @ClassRule
    public static BuildWatcher buildWatcher = new BuildWatcher();
    @Rule
    public JenkinsRule r = new JenkinsRule();

    @Test
    public void smokes() throws Exception {
        BuildTrigger.DescriptorImpl d = (BuildTrigger.DescriptorImpl)this.r.jenkins.getDescriptorByType(BuildTrigger.DescriptorImpl.class);
        FreeStyleProject us = (FreeStyleProject)this.r.createProject(FreeStyleProject.class, "us");
        WorkflowJob ds = (WorkflowJob)this.r.createProject(WorkflowJob.class, "ds");
        ds.setDefinition((FlowDefinition)new CpsFlowDefinition("", true));
        Assert.assertEquals(Collections.singletonList("ds"), (Object)d.doAutoCompleteChildProjects("d", (Item)us, (ItemGroup)this.r.jenkins).getValues());
        FormValidation validation = d.doCheck((AbstractProject)us, "ds");
        Assert.assertEquals((String)validation.renderHtml(), (Object)FormValidation.Kind.OK, (Object)validation.kind);
        us.getPublishersList().add((Object)new BuildTrigger("ds", Result.SUCCESS));
        this.r.jenkins.setQuietPeriod(Integer.valueOf(0));
        FreeStyleBuild us1 = this.r.buildAndAssertSuccess(us);
        this.r.waitUntilNoActivity();
        WorkflowRun ds1 = ds.getLastBuild();
        Assert.assertNotNull((String)"triggered", (Object)ds1);
        Cause.UpstreamCause cause = (Cause.UpstreamCause)ds1.getCause(Cause.UpstreamCause.class);
        Assert.assertNotNull((Object)cause);
        Assert.assertEquals((Object)us1, (Object)cause.getUpstreamRun());
    }
}

