/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.job;

import hudson.cli.CLICommandInvoker;
import hudson.model.Action;
import hudson.model.Executor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import hudson.security.WhoAmI;
import hudson.triggers.SCMTrigger;
import hudson.triggers.Trigger;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jenkins.model.lazy.LazyBuildMixIn;
import jenkins.plugins.git.GitSampleRepoRule;
import net.sf.json.JSONObject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.htmlunit.HttpMethod;
import org.htmlunit.WebRequest;
import org.htmlunit.html.HtmlCheckBoxInput;
import org.htmlunit.html.HtmlForm;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.cps.CpsScmFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.BuildWatcher;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.RunLoadCounter;

public class WorkflowJobTest {
    private static final Logger LOGGER = Logger.getLogger(WorkflowJobTest.class.getName());
    @ClassRule
    public static BuildWatcher watcher = new BuildWatcher();
    @Rule
    public JenkinsRule j = new JenkinsRule();
    @Rule
    public GitSampleRepoRule sampleRepo = new GitSampleRepoRule();

    @Test
    public void getSCM() throws Exception {
        WorkflowJob p = (WorkflowJob)this.j.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n  checkout(new hudson.scm.NullSCM())\n}", false));
        Assert.assertTrue((String)"No runs has been performed and there should be no SCMs", (boolean)p.getSCMs().isEmpty());
        this.j.buildAndAssertSuccess((Job)p);
        Assert.assertEquals((String)"Expecting one SCM", (long)1L, (long)p.getSCMs().size());
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("error 'Fail!'", true));
        this.j.assertBuildStatus(Result.FAILURE, (Future)p.scheduleBuild2(0, new Action[0]));
        Assert.assertEquals((String)"Expecting one SCM even though last run failed", (long)1L, (long)p.getSCMs().size());
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'Pass!'", true));
        this.j.buildAndAssertSuccess((Job)p);
        Assert.assertEquals((String)"Expecting zero SCMs", (long)0L, (long)p.getSCMs().size());
    }

    @Test
    public void polling() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("Jenkinsfile", "echo 'first version'");
        this.sampleRepo.git(new String[]{"add", "Jenkinsfile"});
        this.sampleRepo.git(new String[]{"commit", "-m", "init"});
        WorkflowJob p = (WorkflowJob)this.j.jenkins.createProject(WorkflowJob.class, "p");
        p.addTrigger((Trigger)new SCMTrigger(""));
        p.setDefinition((FlowDefinition)new CpsScmFlowDefinition((SCM)new GitSCM(this.sampleRepo.toString()), "Jenkinsfile"));
        this.j.assertLogContains("first version", this.j.buildAndAssertSuccess((Job)p));
        this.sampleRepo.write("Jenkinsfile", "echo 'second version'");
        this.sampleRepo.git(new String[]{"commit", "-a", "-m", "init"});
        this.j.jenkins.setQuietPeriod(Integer.valueOf(0));
        this.j.createWebClient().getPage(new WebRequest(this.j.createWebClient().createCrumbedUrl(p.getUrl() + "polling"), HttpMethod.POST));
        this.j.waitUntilNoActivity();
        WorkflowRun b2 = p.getLastBuild();
        Assert.assertEquals((long)2L, (long)b2.getNumber());
        this.j.assertLogContains("second version", (Run)b2);
    }

    @Test
    public void nonEmptySCMListForGitSCMJobBeforeBuild() throws Exception {
        WorkflowJob p = (WorkflowJob)this.j.jenkins.createProject(WorkflowJob.class, "p");
        CpsScmFlowDefinition def = new CpsScmFlowDefinition((SCM)new GitSCM("I don't care"), "Jenkinsfile");
        Assert.assertEquals((String)"Expecting one SCM for definition", (long)1L, (long)def.getSCMs().size());
        p.setDefinition((FlowDefinition)def);
        Assert.assertEquals((String)"Expecting one SCM", (long)1L, (long)p.getSCMs().size());
    }

    @Test
    public void neverBuiltSCMBasedJobMustBeTriggerableByHook() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("Jenkinsfile", "echo 'first version'");
        this.sampleRepo.git(new String[]{"add", "Jenkinsfile"});
        this.sampleRepo.git(new String[]{"commit", "-m", "init"});
        WorkflowJob p = (WorkflowJob)this.j.jenkins.createProject(WorkflowJob.class, "p");
        p.addTrigger((Trigger)new SCMTrigger(""));
        p.setDefinition((FlowDefinition)new CpsScmFlowDefinition((SCM)new GitSCM(this.sampleRepo.toString()), "Jenkinsfile"));
        this.j.jenkins.setQuietPeriod(Integer.valueOf(0));
        this.j.createWebClient().getPage(new WebRequest(this.j.createWebClient().createCrumbedUrl(p.getUrl() + "polling"), HttpMethod.POST));
        this.j.waitUntilNoActivity();
        WorkflowRun b1 = p.getLastBuild();
        Assert.assertEquals((long)1L, (long)b1.getNumber());
        this.j.assertLogContains("first version", (Run)b1);
    }

    @Test
    public void addAction() throws Exception {
        WorkflowJob p = (WorkflowJob)this.j.jenkins.createProject(WorkflowJob.class, "p");
        WhoAmI a = new WhoAmI();
        p.addAction((Action)a);
        Assert.assertNotNull((Object)p.getAction(WhoAmI.class));
    }

    @Test
    public void disabled() throws Exception {
        WorkflowJob p = (WorkflowJob)this.j.jenkins.createProject(WorkflowJob.class, "p");
        JenkinsRule.WebClient wc = this.j.createWebClient();
        this.assertDisabled(p, false, wc);
        HtmlForm form = wc.getPage((Item)p, "configure").getFormByName("config");
        HtmlCheckBoxInput checkbox = (HtmlCheckBoxInput)form.getInputByName("enable");
        Assert.assertTrue((boolean)checkbox.isChecked());
        checkbox.setChecked(false);
        this.j.submit(form);
        this.assertDisabled(p, true, wc);
        form = wc.getPage((Item)p, "configure").getFormByName("config");
        checkbox = (HtmlCheckBoxInput)form.getInputByName("enable");
        Assert.assertFalse((boolean)checkbox.isChecked());
        checkbox.setChecked(true);
        this.j.submit(form);
        this.assertDisabled(p, false, wc);
        wc.getPage(new WebRequest(wc.createCrumbedUrl(p.getUrl() + "disable"), HttpMethod.POST));
        this.assertDisabled(p, true, wc);
        Assert.assertNull((Object)p.scheduleBuild2(0, new Action[0]));
        MatcherAssert.assertThat((Object)new CLICommandInvoker(this.j, "enable-job").invokeWithArgs(new String[]{"p"}), (Matcher)CLICommandInvoker.Matcher.succeededSilently());
        this.assertDisabled(p, false, wc);
    }

    private void assertDisabled(WorkflowJob p, boolean disabled, JenkinsRule.WebClient wc) throws Exception {
        MatcherAssert.assertThat((Object)p.isDisabled(), (Matcher)Matchers.is((Object)disabled));
        MatcherAssert.assertThat((Object)p.isBuildable(), (Matcher)Matchers.is((Object)(!disabled ? 1 : 0)));
        MatcherAssert.assertThat((Object)wc.getJSON(p.getUrl() + "api/json?tree=disabled,buildable").getJSONObject(), (Matcher)Matchers.is((Object)new JSONObject().accumulate("_class", (Object)WorkflowJob.class.getName()).accumulate("disabled", disabled).accumulate("buildable", !disabled)));
    }

    @Test
    public void newBuildsShouldNotLoadOld() throws Throwable {
        WorkflowJob p = (WorkflowJob)this.j.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("", true));
        for (int i = 0; i < 10; ++i) {
            this.j.buildAndAssertSuccess((Job)p);
        }
        RunLoadCounter.assertMaxLoads((LazyBuildMixIn.LazyLoadingJob)p, (int)1, () -> {
            for (int i = 0; i < 5; ++i) {
                this.j.buildAndAssertSuccess((Job)p);
            }
            return null;
        });
    }

    @Test
    public void deletionShouldWaitForBuildsToComplete() throws Throwable {
        WorkflowJob p = (WorkflowJob)this.j.createProject(WorkflowJob.class);
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("try {\n  echo 'about to sleep'\n  sleep 999\n} catch(e) {\n  echo 'aborting soon'\n  sleep 3\n}\n", true));
        WorkflowRun b = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        this.j.waitForMessage("about to sleep", (Run)b);
        LOGGER.info(() -> "Deleting " + String.valueOf(p));
        p.delete();
        LOGGER.info(() -> "Deleted " + String.valueOf(p));
        MatcherAssert.assertThat((Object)this.j.jenkins.getItemByFullName(p.getFullName()), (Matcher)Matchers.nullValue());
        List executables = Stream.of(this.j.jenkins.getComputers()).flatMap(c -> c.getAllExecutors().stream()).map(Executor::getCurrentExecutable).filter(Objects::nonNull).collect(Collectors.toList());
        MatcherAssert.assertThat(executables, (Matcher)Matchers.empty());
    }
}

