/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.job;

import hudson.model.Action;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.model.Result;
import hudson.triggers.Trigger;
import java.util.concurrent.Future;
import jenkins.triggers.ReverseBuildTrigger;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.BuildWatcher;
import org.jvnet.hudson.test.JenkinsSessionRule;
import org.jvnet.hudson.test.TestExtension;

public class ReverseBuildTriggerTest {
    @ClassRule
    public static BuildWatcher buildWatcher = new BuildWatcher();
    @Rule
    public JenkinsSessionRule sessions = new JenkinsSessionRule();

    @Test
    public void upstreamMapRebuilding() throws Throwable {
        this.sessions.then(r -> {
            r.jenkins.setQuietPeriod(Integer.valueOf(0));
            WorkflowJob us = (WorkflowJob)r.jenkins.createProject(WorkflowJob.class, "us");
            us.setDefinition((FlowDefinition)new CpsFlowDefinition("", true));
            us.addProperty((JobProperty)new SlowToLoad());
            WorkflowJob ds = (WorkflowJob)r.jenkins.createProject(WorkflowJob.class, "ds");
            ds.setDefinition((FlowDefinition)new CpsFlowDefinition("", true));
            ReverseBuildTrigger trigger = new ReverseBuildTrigger("us");
            trigger.setThreshold(Result.SUCCESS);
            ds.addTrigger((Trigger)trigger);
            r.assertBuildStatusSuccess((Future)us.scheduleBuild2(0, new Action[0]));
            r.waitUntilNoActivity();
            WorkflowRun ds1 = (WorkflowRun)ds.getLastCompletedBuild();
            Assert.assertNotNull((Object)ds1);
            Assert.assertEquals((long)1L, (long)ds1.getNumber());
        });
        this.sessions.then(r -> {
            WorkflowJob us = (WorkflowJob)r.jenkins.getItemByFullName("us", WorkflowJob.class);
            Assert.assertNotNull((Object)us);
            WorkflowJob ds = (WorkflowJob)r.jenkins.getItemByFullName("ds", WorkflowJob.class);
            Assert.assertNotNull((Object)ds);
            r.assertBuildStatusSuccess((Future)us.scheduleBuild2(0, new Action[0]));
            r.waitUntilNoActivity();
            WorkflowRun ds2 = (WorkflowRun)ds.getLastCompletedBuild();
            Assert.assertNotNull((Object)ds2);
            Assert.assertEquals((long)2L, (long)ds2.getNumber());
        });
    }

    public static class SlowToLoad
    extends JobProperty<WorkflowJob> {
        protected void setOwner(WorkflowJob owner) {
            super.setOwner((Job)owner);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException x) {
                throw new AssertionError((Object)x);
            }
        }

        @TestExtension(value={"upstreamMapRebuilding"})
        public static class DescriptorImpl
        extends JobPropertyDescriptor {
        }
    }
}

