/*
 * Decompiled with CFR 0.152.
 */
package hudson.views;

import hudson.model.ListView;
import hudson.model.View;
import hudson.model.ViewGroup;
import hudson.views.JenkinsUtil;
import hudson.views.OtherViewsFilter;
import hudson.views.UnclassifiedJobsFilter;
import hudson.views.ViewJobFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.alg.cycle.TarjanSimpleCycles;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

public class ViewGraph {
    private final Map<String, View> views;
    private DefaultDirectedGraph<String, DefaultEdge> graph;
    private Set<List<View>> cycles;
    private Set<View> viewsInCycles;
    private Set<View> viewsNotInCycles;
    private static final Comparator<List<String>> SORT_BY_SIZE_DESC = new Comparator<List<String>>(){

        @Override
        public int compare(List<String> o1, List<String> o2) {
            return Integer.compare(o2.size(), o1.size());
        }
    };
    private static final ThreadLocal<Boolean> isGetAllViewsAlreadyRunning = new ThreadLocal();

    public ViewGraph() {
        this(ViewGraph.getAllViewsByName());
    }

    public ViewGraph(Map<String, View> views) {
        this.views = views;
    }

    private DefaultDirectedGraph<String, DefaultEdge> getGraph() {
        if (this.graph != null) {
            return this.graph;
        }
        this.graph = new DefaultDirectedGraph(DefaultEdge.class);
        for (String string : this.views.keySet()) {
            this.graph.addVertex((Object)string);
        }
        for (Map.Entry entry : this.views.entrySet()) {
            String viewName = (String)entry.getKey();
            View view = (View)entry.getValue();
            for (ViewJobFilter filter : this.getViewJobFilters(view)) {
                String otherViewName;
                if (filter instanceof UnclassifiedJobsFilter) {
                    for (String otherViewName2 : this.views.keySet()) {
                        if (otherViewName2.equals(viewName)) continue;
                        this.graph.addEdge((Object)viewName, (Object)otherViewName2);
                    }
                    continue;
                }
                if (!(filter instanceof OtherViewsFilter) || (otherViewName = ((OtherViewsFilter)filter).getOtherViewName()) == null) continue;
                this.graph.addEdge((Object)viewName, (Object)otherViewName);
            }
        }
        return this.graph;
    }

    private List<ViewJobFilter> getViewJobFilters(View view) {
        if (view instanceof ListView) {
            return ((ListView)view).getJobFilters();
        }
        return Collections.emptyList();
    }

    public Set<List<View>> getCycles() {
        if (this.cycles == null) {
            List cycles = new TarjanSimpleCycles(this.getGraph()).findSimpleCycles();
            Collections.sort(cycles, SORT_BY_SIZE_DESC);
            HashSet<List<String>> uniqueCycles = new HashSet<List<String>>();
            for (List cycle : cycles) {
                if (this.cycleIsSubsetOfOtherCycle(cycle, uniqueCycles)) continue;
                uniqueCycles.add(cycle);
            }
            this.cycles = this.toViewCyles(uniqueCycles);
        }
        return this.cycles;
    }

    private Set<List<View>> toViewCyles(Set<List<String>> cycles) {
        HashSet<List<View>> viewCyles = new HashSet<List<View>>();
        for (List<String> cycle : cycles) {
            ArrayList<View> viewCycle = new ArrayList<View>();
            for (String viewName : cycle) {
                viewCycle.add(this.views.get(viewName));
            }
            viewCyles.add(viewCycle);
        }
        return viewCyles;
    }

    public List<View> getFirstCycleWithView(View view) {
        Set<List<View>> cycles = this.getCycles();
        for (List<View> cycle : cycles) {
            if (!cycle.contains(view)) continue;
            return cycle;
        }
        return null;
    }

    private boolean cycleIsSubsetOfOtherCycle(List<String> cycle, Set<List<String>> otherCycles) {
        for (List<String> otherCycle : otherCycles) {
            if (!otherCycle.containsAll(cycle)) continue;
            return true;
        }
        return false;
    }

    public Set<View> getViewsInCycles() {
        if (this.viewsInCycles == null) {
            HashSet<View> viewsInCycles = new HashSet<View>();
            for (List<View> cycle : this.getCycles()) {
                for (View view : cycle) {
                    viewsInCycles.add(view);
                }
            }
            this.viewsInCycles = viewsInCycles;
        }
        return this.viewsInCycles;
    }

    public Set<View> getViewsNotInCycles() {
        if (this.viewsNotInCycles == null) {
            HashSet<View> viewsNotInCycles = new HashSet<View>();
            for (View view : this.views.values()) {
                if (this.getViewsInCycles().contains(view)) continue;
                viewsNotInCycles.add(view);
            }
            this.viewsNotInCycles = viewsNotInCycles;
        }
        return this.viewsNotInCycles;
    }

    private static void addViews(View view, List<View> views) {
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            Collection subViews = group.getViews();
            for (View sub : subViews) {
                ViewGraph.addViews(sub, views);
            }
        } else {
            views.add(view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<View> getAllViews() {
        ArrayList<View> views = new ArrayList<View>();
        if (Boolean.TRUE.equals(isGetAllViewsAlreadyRunning.get())) {
            return views;
        }
        isGetAllViewsAlreadyRunning.set(Boolean.TRUE);
        try {
            Collection baseViews = JenkinsUtil.getInstance().getViews();
            for (View view : baseViews) {
                ViewGraph.addViews(view, views);
            }
            ArrayList<View> arrayList = views;
            return arrayList;
        }
        finally {
            isGetAllViewsAlreadyRunning.remove();
        }
    }

    public static Map<String, View> getAllViewsByName() {
        HashMap<String, View> views = new HashMap<String, View>();
        for (View view : ViewGraph.getAllViews()) {
            views.put(ViewGraph.toName(view), view);
        }
        return views;
    }

    public static View getView(String name) {
        List<View> views = ViewGraph.getAllViews();
        for (View view : views) {
            String otherName = ViewGraph.toName(view);
            if (!otherName.equals(name)) continue;
            return view;
        }
        return null;
    }

    public static String toName(View view) {
        View ownerView;
        Object name = view.getViewName();
        ViewGroup owner = view.getOwner();
        if (owner instanceof View && !(ownerView = (View)owner).equals(view)) {
            String parentName = ViewGraph.toName((View)owner);
            name = parentName + " / " + (String)name;
        }
        return name;
    }

    public static String toName(List<View> cycle) {
        StringBuilder builder = new StringBuilder();
        for (View view : cycle) {
            builder.append(ViewGraph.toName(view));
            builder.append(" -> ");
        }
        builder.append(ViewGraph.toName(cycle.get(0)));
        return builder.toString();
    }
}

