/*
 * Decompiled with CFR 0.152.
 */
package hudson.views;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.TopLevelItem;
import hudson.views.AbstractIncludeExcludeJobFilter;
import hudson.views.MatrixAuthorizationHelper;
import hudson.views.PluginHelperUtils;
import hudson.views.ViewJobFilter;
import hudson.views.filters.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class SecuredJobsFilter
extends AbstractIncludeExcludeJobFilter {
    public static final MatrixAuthorizationHelper MATRIX_AUTHORIZATION_HELPER = SecuredJobsFilter.buildMatrixAuthorizationHelper();

    @DataBoundConstructor
    public SecuredJobsFilter(String includeExcludeTypeString) {
        super(includeExcludeTypeString);
    }

    @Override
    protected boolean matches(TopLevelItem item) {
        if (item instanceof Job) {
            Job job = (Job)item;
            if (MATRIX_AUTHORIZATION_HELPER != null) {
                JobProperty prop = job.getProperty(MATRIX_AUTHORIZATION_HELPER.getPluginTesterClass());
                return prop != null;
            }
            return false;
        }
        return false;
    }

    private static MatrixAuthorizationHelper buildMatrixAuthorizationHelper() {
        try {
            return PluginHelperUtils.validateAndThrow(new MatrixAuthorizationHelper());
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ViewJobFilter> {
        public String getDisplayName() {
            return Messages.SecuredJobsFilter_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/view-job-filters/secured-jobs-help.html";
        }
    }
}

