/*
 * Decompiled with CFR 0.152.
 */
package hudson.views;

import hudson.scm.SCM;
import hudson.views.CvsValuesProvider;
import hudson.views.GitValuesProvider;
import hudson.views.ScmValuesProvider;
import hudson.views.SvnValuesProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ScmFilterHelper {
    public static final List<ScmValuesProvider> matchers = ScmFilterHelper.buildMatchers();

    public static List<String> getValues(SCM scm) {
        ArrayList<String> values = new ArrayList<String>();
        if (scm == null) {
            return values;
        }
        for (ScmValuesProvider matcher : matchers) {
            List<String> some;
            if (!matcher.checkLoaded() || (some = matcher.getValues(scm)) == null) continue;
            values.addAll(some);
        }
        return values;
    }

    private static List<ScmValuesProvider> buildMatchers() {
        ArrayList<ScmValuesProvider> matchers = new ArrayList<ScmValuesProvider>();
        try {
            matchers.add(ScmFilterHelper.buildSvn());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            matchers.add(ScmFilterHelper.buildCvs());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            matchers.add(ScmFilterHelper.buildGit());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Collections.unmodifiableList(matchers);
    }

    private static ScmValuesProvider buildSvn() {
        return new SvnValuesProvider();
    }

    private static ScmValuesProvider buildCvs() {
        return new CvsValuesProvider();
    }

    private static ScmValuesProvider buildGit() {
        return new GitValuesProvider();
    }
}

