/*
 * Decompiled with CFR 0.152.
 */
package hudson.views;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.views.ViewJobFilter;
import hudson.views.filters.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

public class MostRecentJobsFilter
extends ViewJobFilter {
    private int maxToInclude;
    private boolean checkStartTime;
    private static final transient Logger log = Logger.getLogger("MostRecentJobsFilter");

    @DataBoundConstructor
    public MostRecentJobsFilter(int maxToInclude, boolean checkStartTime) {
        this.maxToInclude = maxToInclude;
        this.checkStartTime = checkStartTime;
    }

    public List<TopLevelItem> filter(List<TopLevelItem> added, List<TopLevelItem> all, View filteringView) {
        ArrayList<TopLevelItem> filtered = new ArrayList<TopLevelItem>(added);
        Collections.sort(filtered, new MostRecentJobsComparator());
        int max = this.maxToInclude;
        if (max > filtered.size()) {
            max = filtered.size();
        }
        ArrayList<TopLevelItem> subList = new ArrayList<TopLevelItem>();
        for (int i = 0; i < max; ++i) {
            subList.add((TopLevelItem)filtered.get(i));
        }
        return subList;
    }

    private long getTime(Job job) {
        for (Run run = job.getLastBuild(); run != null; run = run.getPreviousBuild()) {
            if (this.checkStartTime) {
                return run.getTimeInMillis();
            }
            if (run.isBuilding()) continue;
            return run.getTimeInMillis() + run.getDuration();
        }
        return Long.MIN_VALUE;
    }

    public boolean isCheckStartTime() {
        return this.checkStartTime;
    }

    public int getMaxToInclude() {
        return this.maxToInclude;
    }

    private class MostRecentJobsComparator
    implements Comparator<TopLevelItem> {
        private MostRecentJobsComparator() {
        }

        @Override
        public int compare(TopLevelItem i1, TopLevelItem i2) {
            if (!(i1 instanceof Job) && !(i2 instanceof Job)) {
                return 0;
            }
            if (!(i1 instanceof Job)) {
                return -1;
            }
            if (!(i2 instanceof Job)) {
                return 1;
            }
            Job j1 = (Job)i1;
            Job j2 = (Job)i2;
            Long t1 = MostRecentJobsFilter.this.getTime(j1);
            Long t2 = MostRecentJobsFilter.this.getTime(j2);
            return t2.compareTo(t1);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ViewJobFilter> {
        public String getDisplayName() {
            return Messages.MostRecentJobsFilter_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/view-job-filters/most-recent-jobs-help.html";
        }
    }
}

