/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.model.ExternalJob;
import hudson.model.ExternalRun;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import org.kohsuke.args4j.Option;

@Extension
public class SetExternalBuildResultCommand
extends CLICommand {
    @Option(name="--job", aliases={"-j"}, metaVar="JOB", usage="Name of the external monitor job", required=true)
    public transient TopLevelItem job;
    @Option(name="--display", aliases={"-n"}, metaVar="DISPLAY", usage="Display name of the build", required=false)
    public transient String displayName;
    @Option(name="--result", aliases={"-r"}, metaVar="RESULT", usage="0: success, 1: fail", required=false)
    public transient int result = 0;
    @Option(name="--duration", aliases={"-d"}, metaVar="DURATION", usage="Number of milli-seconds it took to run this build", required=false)
    public transient long duration = 0L;
    @Option(name="--log", aliases={"-l"}, metaVar="-|LOG", usage="Log to be set. '-' to read from stdin (gzipped).", required=true)
    public String log;
    @Option(name="--dump-build-number", aliases={"-b"}, usage="Log the produced build number to the standard output", required=false)
    public boolean dumpBuildNumber;

    public String getShortDescription() {
        return "Set external monitor job result.";
    }

    protected int run() throws Exception {
        ExternalRun run = ((ExternalJob)this.job).newBuild();
        run.checkPermission(Run.UPDATE);
        if ("-".equals(this.log)) {
            run.acceptRemoteSubmission(this.result, this.duration, this.stdin);
        } else {
            run.acceptRemoteSubmission(this.result, this.duration, this.log);
        }
        if (this.displayName != null) {
            run.setDisplayName(this.displayName);
        }
        if (this.dumpBuildNumber) {
            this.stdout.println(run.getNumber());
        }
        return 0;
    }
}

