/*
 * Decompiled with CFR 0.152.
 */
package com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.features;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.BuildViewModel;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.JobView;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.features.Feature;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.jenkinsci.plugins.junitrealtimetestreporter.AbstractRealtimeTestResultAction;
import org.jenkinsci.plugins.junitrealtimetestreporter.TestProgress;

public class HasJunitRealtime
implements Feature<RealtimeTests> {
    private ActionFilter filter = new ActionFilter();
    private JobView job;

    @Override
    public HasJunitRealtime of(JobView jobView) {
        this.job = jobView;
        return this;
    }

    @Override
    public RealtimeTests asJson() {
        List<BuildViewModel> builds = this.job.currentBuilds();
        if (builds.isEmpty()) {
            return null;
        }
        BuildViewModel build = builds.get(0);
        Iterator<AbstractRealtimeTestResultAction> details = build.allDetailsOf(AbstractRealtimeTestResultAction.class).stream().filter(this.filter).iterator();
        return details.hasNext() ? new RealtimeTests(details) : null;
    }

    private static class ActionFilter
    implements Predicate<AbstractRealtimeTestResultAction> {
        private ActionFilter() {
        }

        @Override
        public boolean test(AbstractRealtimeTestResultAction action) {
            action.getResult();
            return action.getTestProgress() != null;
        }
    }

    public static class RealtimeTests {
        private final List<RealtimeTest> realtimeTests = new ArrayList<RealtimeTest>();

        public RealtimeTests(Iterator<AbstractRealtimeTestResultAction> realtimeTestResultAction) {
            while (realtimeTestResultAction.hasNext()) {
                AbstractRealtimeTestResultAction action = realtimeTestResultAction.next();
                this.realtimeTests.add(new RealtimeTest(action.getTestProgress(), action.getFailCount()));
            }
        }

        @JsonValue
        public List<RealtimeTest> value() {
            return List.copyOf(this.realtimeTests);
        }
    }

    public static class RealtimeTest {
        private final TestProgress testProgress;
        private final int failCount;

        public RealtimeTest(TestProgress testProgress, int failCount) {
            this.testProgress = testProgress;
            this.failCount = failCount;
        }

        @JsonProperty
        public String getEstimatedRemainingTime() {
            return this.testProgress.getEstimatedRemainingTime();
        }

        @JsonProperty
        public int[] getCompletedPercentages() {
            int value1 = Math.min(this.testProgress.getCompletedTestsPercentage(), this.testProgress.getCompletedTimePercentage());
            int value2 = Math.max(this.testProgress.getCompletedTestsPercentage(), this.testProgress.getCompletedTimePercentage());
            return new int[]{value1, value2 - value1};
        }

        @JsonProperty
        public int getCompletedTests() {
            return this.testProgress.getCompletedTests();
        }

        @JsonProperty
        public int getExpectedTests() {
            return this.testProgress.getExpectedTests();
        }

        @JsonProperty
        public String getStyle() {
            if (this.failCount > 0) {
                return "red";
            }
            return "";
        }
    }
}

