/*
 * Decompiled with CFR 0.152.
 */
package com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.features;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.jenkinsci.plugins.badge.action.BadgeAction;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.Config;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.JobView;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.features.Feature;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class HasBadgesBadgePlugin
implements Feature<Badges> {
    private final Config config;
    private ActionFilter filter = new ActionFilter();
    private JobView job;

    public HasBadgesBadgePlugin(Config config) {
        this.config = config;
    }

    @Override
    public HasBadgesBadgePlugin of(JobView jobView) {
        this.job = jobView;
        return this;
    }

    @Override
    public Badges asJson() {
        Iterator<BadgeAction> badges = this.config.getDisplayBadgesFrom().from(this.job).allDetailsOf(BadgeAction.class).stream().filter(this.filter).iterator();
        return badges.hasNext() ? new Badges(badges) : null;
    }

    private static class ActionFilter
    implements Predicate<BadgeAction> {
        private ActionFilter() {
        }

        @Override
        public boolean test(BadgeAction action) {
            return action.getIcon() == null;
        }
    }

    public static class Badges {
        private final List<Badge> badges = new ArrayList<Badge>();

        public Badges(Iterator<BadgeAction> badgeActions) {
            while (badgeActions.hasNext()) {
                this.badges.add(new Badge(badgeActions.next()));
            }
        }

        @JsonValue
        public List<Badge> value() {
            return List.copyOf(this.badges);
        }
    }

    public static class Badge {
        private final BadgeAction badge;
        private static final Pattern BADGE_STYLE_PATTERN = Pattern.compile("(border: (?<border>.*) solid (?<borderColor>.*);)?(background: (?<background>.*);)?(color: (?<color>.*);)?");

        public Badge(BadgeAction badge) {
            this.badge = badge;
        }

        @JsonProperty
        public final String text() {
            return this.badge.getText();
        }

        @JsonProperty
        public final String color() {
            return null;
        }

        @JsonProperty
        public final String background() {
            return null;
        }

        @JsonProperty
        public final String border() {
            return null;
        }

        @JsonProperty
        public final String borderColor() {
            return null;
        }
    }
}

