/*
 * Decompiled with CFR 0.152.
 */
package com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.features;

import com.fasterxml.jackson.annotation.JsonValue;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.Config;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.JobView;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.features.Feature;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseBuildAction;
import com.sonyericsson.jenkins.plugins.bfa.model.FoundFailureCause;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class CanBeDiagnosedForProblems
implements Feature<Problems> {
    private JobView job;
    private Config.BuildFailureAnalyzerDisplayedField displayedField;

    public CanBeDiagnosedForProblems(Config.BuildFailureAnalyzerDisplayedField displayedField) {
        this.displayedField = displayedField;
    }

    @Override
    public CanBeDiagnosedForProblems of(JobView jobView) {
        this.job = jobView;
        return this;
    }

    @Override
    public Problems asJson() {
        Optional<FailureCauseBuildAction> details = this.job.lastCompletedBuild().detailsOf(FailureCauseBuildAction.class);
        return details.map(failureCauseBuildAction -> new Problems((FailureCauseBuildAction)failureCauseBuildAction, this.displayedField)).orElse(null);
    }

    public static class Problems {
        private final List<String> failures = new ArrayList<String>();

        public Problems(FailureCauseBuildAction action, Config.BuildFailureAnalyzerDisplayedField displayedField) {
            if (displayedField != Config.BuildFailureAnalyzerDisplayedField.None) {
                for (FoundFailureCause failure : action.getFoundFailureCauses()) {
                    String str = displayedField == Config.BuildFailureAnalyzerDisplayedField.Description ? failure.getDescription() : failure.getName();
                    if (str == null) continue;
                    this.failures.add(str);
                }
            }
        }

        @JsonValue
        public List<String> value() {
            return List.copyOf(this.failures);
        }
    }
}

