/*
 * Decompiled with CFR 0.152.
 */
package com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.duration;

import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.duration.Duration;

public class HumanReadableDuration
extends Duration {
    private static final long MILLISECOND = 1L;
    private static final long SECONDS = 1000L;
    private static final long MINUTES = 60000L;
    private static final long HOURS = 3600000L;

    public HumanReadableDuration(long milliseconds) {
        super(milliseconds);
    }

    private long hours() {
        return this.duration / 3600000L;
    }

    private long minutes() {
        return (this.duration - this.hours() * 3600000L) / 60000L;
    }

    private long seconds() {
        return (this.duration - this.hours() * 3600000L - this.minutes() * 60000L) / 1000L;
    }

    @Override
    public String value() {
        Object formatted = this.hours() > 0L ? this.hours() + "h " : "";
        formatted = (String)formatted + (String)(this.minutes() > 0L ? this.minutes() + "m " : "");
        formatted = (String)formatted + this.seconds() + "s";
        return formatted;
    }

    public String toString() {
        return this.value();
    }
}

