/*
 * Decompiled with CFR 0.152.
 */
package com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.facade.RelativeLocation;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.BuildView;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.BuildViewModel;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.BuildingPredicate;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.CssStatus;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.JobViewSerialiser;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.NullBuildView;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.duration.Duration;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.features.Feature;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.ViewJob;
import hudson.util.RunList;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

@JsonSerialize(using=JobViewSerialiser.class)
public class JobView {
    private final Date systemTime;
    private final Job<?, ?> job;
    private final boolean isPipelineJob;
    private final RelativeLocation relative;
    private final List<Feature> features = new ArrayList<Feature>();

    public static JobView of(Job<?, ?> job, List<Feature> features, boolean isPipelineJob) {
        return new JobView(job, features, isPipelineJob, RelativeLocation.of(job), new Date());
    }

    public JobView(Job<?, ?> job, List<Feature> features, boolean isPipelineJob, RelativeLocation relative, Date systemTime) {
        this.job = job;
        this.isPipelineJob = isPipelineJob;
        this.relative = relative;
        this.systemTime = systemTime;
        for (Feature feature : features) {
            this.features.add((Feature)feature.of(this));
        }
    }

    public List<Feature> features() {
        return List.copyOf(this.features);
    }

    public <F extends Feature> F which(Class<F> requestedFeature) {
        for (Feature feature : this.features) {
            if (feature.getClass() != requestedFeature) continue;
            return (F)feature;
        }
        throw new RuntimeException(String.format("%s is not a feature of this project: '%s'", requestedFeature.getSimpleName(), this.job.getName()));
    }

    public String name() {
        return this.relative.name();
    }

    public String url() {
        return this.relative.url();
    }

    public String status() {
        return CssStatus.of(this);
    }

    public String estimatedDuration() {
        return this.formatted(this.lastBuild().estimatedDuration());
    }

    public String timeElapsedSinceLastBuild() {
        return this.formatted(this.lastCompletedBuild().timeElapsedSince());
    }

    private String formatted(Duration duration) {
        return null != duration ? duration.value() : "";
    }

    public int progress() {
        return this.lastBuild().progress();
    }

    public boolean isDisabled() {
        return !this.isJobBuildable() && !this.isJobExternal();
    }

    private boolean isJobBuildable() {
        return this.job.isBuildable();
    }

    private boolean isJobExternal() {
        return this.job instanceof ViewJob;
    }

    public boolean isRunning() {
        return this.lastBuild().isRunning();
    }

    public Result lastResult() {
        return this.lastCompletedBuild().result();
    }

    public int hashCode() {
        return Objects.hashCode(this.job.hashCode());
    }

    public boolean equals(Object obj) {
        return Objects.equals(this.job, obj);
    }

    public String toString() {
        return this.name();
    }

    public List<BuildViewModel> currentBuilds() {
        ArrayList<BuildViewModel> currentBuilds = new ArrayList<BuildViewModel>();
        RunList runList = this.job.getNewBuilds().filter((Predicate)BuildingPredicate.INSTANCE);
        for (Run run : runList) {
            currentBuilds.add(this.buildViewOf(run));
        }
        return currentBuilds;
    }

    public BuildViewModel lastBuild() {
        return this.buildViewOf(this.job.getLastBuild());
    }

    public BuildViewModel lastCompletedBuild() {
        BuildViewModel previousBuild = this.lastBuild();
        while (previousBuild.isRunning() && previousBuild.hasPreviousBuild()) {
            previousBuild = previousBuild.previousBuild();
        }
        return previousBuild;
    }

    private BuildViewModel buildViewOf(Run<?, ?> build) {
        if (null == build) {
            return new NullBuildView();
        }
        return BuildView.of(build, this.isPipelineJob, this.relative, this.systemTime);
    }
}

