/*
 * Decompiled with CFR 0.152.
 */
package com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel;

import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.JobView;
import hudson.model.Result;
import java.util.Map;

public class CssStatus {
    private static final Map<Result, String> statuses = Map.of(Result.SUCCESS, "successful", Result.UNSTABLE, "unstable", Result.FAILURE, "failing", Result.NOT_BUILT, "unknown", Result.ABORTED, "aborted");

    public static String of(JobView job) {
        Result result = job.lastResult();
        String status = result == null ? "unknown" : statuses.getOrDefault(result, "unknown");
        if (job.isDisabled()) {
            status = "disabled";
        }
        if (job.isRunning()) {
            status = "running";
        }
        return status;
    }
}

