/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.jenkins.tasks.configuration.build_steps;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ShellScript {
    private final String description;
    private String code = "";

    public static ShellScript that(String descriptionOfScriptsBehaviour) {
        return new ShellScript(descriptionOfScriptsBehaviour);
    }

    public ShellScript definedAs(String ... lines) {
        return this.definedAs(List.of(lines));
    }

    public ShellScript definedAs(List<String> lines) {
        this.code = String.join((CharSequence)"\n", lines);
        return this;
    }

    public ShellScript andOutputs(String ... lines) {
        return this.definedAs(Stream.of(lines).map(line -> String.format("echo \"%s\";", line)).collect(Collectors.toList()));
    }

    public String code() {
        return this.code;
    }

    public String toString() {
        return this.description;
    }

    private ShellScript(String descriptionOfScriptsBehaviour) {
        this.description = descriptionOfScriptsBehaviour;
    }
}

