/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.jenkins.tasks;

import net.serenitybdd.annotations.Step;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Performable;
import net.serenitybdd.screenplay.Task;
import net.serenitybdd.screenplay.Tasks;
import net.serenitybdd.screenplay.actions.Click;
import net.serenitybdd.screenplay.actions.Enter;
import net.serenitybdd.screenplay.jenkins.actions.Choose;
import net.serenitybdd.screenplay.jenkins.tasks.configuration.TodoList;
import net.serenitybdd.screenplay.jenkins.user_interface.NewJobPage;
import net.serenitybdd.screenplay.jenkins.user_interface.navigation.Buttons;
import net.serenitybdd.screenplay.jenkins.user_interface.navigation.SidePanel;
import net.serenitybdd.screenplay.targets.Target;
import net.serenitybdd.screenplayx.actions.Scroll;

class CreateAProject
implements Task {
    private final String name;
    private final TodoList configureTheProject = TodoList.empty();
    private Target projectType;

    public static CreateAProject called(String name) {
        return (CreateAProject)Tasks.instrumented(CreateAProject.class, (Object[])new Object[]{name});
    }

    public CreateAProject ofType(Target projectType) {
        this.projectType = projectType;
        return this;
    }

    public CreateAProject andConfigureItTo(Task configurationTask) {
        this.configureTheProject.add(configurationTask);
        return this;
    }

    @Step(value="{0} creates a 'Freestyle Project' called '#name'")
    public <T extends Actor> void performAs(T actor) {
        actor.attemptsTo(new Performable[]{Click.on((Target)SidePanel.New_Item_Link), Enter.theValue((CharSequence[])new CharSequence[]{this.name}).into(NewJobPage.Item_Name_Field), Choose.the(this.projectType), Scroll.to(Buttons.OK), Click.on((Target)Buttons.OK), this.configureTheProject, Click.on((Target)Buttons.Save)});
    }

    public CreateAProject(String jobName) {
        this.name = jobName;
    }
}

