/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.integration.jenkins.logging;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import net.serenitybdd.integration.jenkins.logging.Witness;

public class LoggerOutputStream
extends OutputStream {
    private Witness witness;
    private String buffer;

    public LoggerOutputStream(Witness witness) {
        this.witness = witness;
        this.buffer = "";
    }

    @Override
    public void write(int b) {
        byte[] bytes = new byte[]{(byte)(b & 0xFF)};
        this.buffer = this.buffer + new String(bytes, StandardCharsets.UTF_8);
        if (this.buffer.endsWith("\n")) {
            this.buffer = this.buffer.substring(0, this.buffer.length() - 1);
            this.flush();
        }
    }

    @Override
    public void flush() {
        this.witness.note(this.buffer);
        this.buffer = "";
    }
}

