/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.integration.jenkins.environment;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Path;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import net.serenitybdd.integration.jenkins.environment.rules.FindFreePort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginDescription {
    private static final Logger Log = LoggerFactory.getLogger(FindFreePort.class);
    private final Path path;
    private final String fullName;
    private final String version;
    private final String requiredJenkinsVersion;

    public static PluginDescription of(@NonNull Path pluginAtPath) {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(pluginAtPath.toFile());
            Attributes attrs = jarFile.getManifest().getMainAttributes();
            PluginDescription pluginDescription = new PluginDescription(pluginAtPath, attrs.getValue("Long-Name"), attrs.getValue("Plugin-Version"), attrs.getValue("Jenkins-Version"));
            return pluginDescription;
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Couldn't read the manifest file of '%s'.", pluginAtPath.toAbsolutePath()), e);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    Log.error("error closing jarFile", (Throwable)e);
                }
            }
        }
    }

    public PluginDescription(@NonNull Path pathToPluginUnderTest, @NonNull String fullName, @NonNull String version, @NonNull String requiredJenkinsVersion) {
        this.path = pathToPluginUnderTest;
        this.fullName = fullName;
        this.version = version;
        this.requiredJenkinsVersion = requiredJenkinsVersion;
    }

    public Path path() {
        return this.path;
    }

    public String fullName() {
        return this.fullName;
    }

    public String version() {
        return this.version;
    }

    public String requiredJenkinsVersion() {
        return this.requiredJenkinsVersion;
    }
}

