/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.integration.jenkins.client;

import hudson.cli.CLI;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import net.serenitybdd.integration.jenkins.process.JenkinsProcess;
import org.jdeferred.Promise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenkinsClient {
    private static final Logger logger = LoggerFactory.getLogger(JenkinsClient.class);
    private static final int Max_Wait_Time = 300000;
    private static String OS = System.getProperty("os.name").toLowerCase();
    private static String OS_VERSION = System.getProperty("os.version").toLowerCase();
    private final JenkinsProcess process;
    private final URL jenkinsUrl;

    public JenkinsClient(URL jenkinsUrl, JenkinsProcess process) {
        this.process = process;
        this.jenkinsUrl = jenkinsUrl;
    }

    public void registerAccount(String username, String password) {
        logger.info("Enabling Jenkins Security and registering account for '{}', identified by '{}'", (Object)username, (Object)password);
        String endScriptMessage = String.format("Account for '%s' created", username);
        Promise<Matcher, ?, ?> promise = this.process.promiseWhen(endScriptMessage);
        try {
            this.executeGroovy(promise, "def instance         = jenkins.model.Jenkins.get()", "def usersCanRegister = true", "def realm            = new hudson.security.HudsonPrivateSecurityRealm(usersCanRegister)", String.format("realm.createAccount(\"%s\",\"%s\")", username, password), "instance.setSecurityRealm(realm)", "instance.save()", "", "import java.util.logging.Logger", "Logger rootLogger = Logger.getLogger('')", String.format("rootLogger.info(\"%s\")", endScriptMessage));
            logger.info(endScriptMessage);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Couldn't enable Jenkins Security", e);
        }
    }

    public void populateUpdateCenterCaches() {
        logger.info("FETCHING UPDATE CENTER");
        String endScriptMessage = "UPDATE CENTER RELOADED";
        Promise<Matcher, ?, ?> promise = this.process.promiseWhen(endScriptMessage);
        try {
            this.executeGroovy(promise, "def ucUrl = new URL('http://updates.jenkins-ci.org/update-center.json')", "def json  = hudson.model.DownloadService.loadJSON(ucUrl)", "def site  = jenkins.model.Jenkins.instance.updateCenter.getById('default')", "site.updateData(json, false)", "", "import java.util.logging.Logger", "Logger rootLogger = Logger.getLogger('')", String.format("rootLogger.info(\"%s\")", endScriptMessage));
            logger.info(endScriptMessage);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Couldn't update the Update Center caches.", e);
        }
    }

    public void installPlugin(String pluginName) {
        this.executeCommand("install-plugin", pluginName, "-restart");
        this.process.waitUntil("Jenkins is fully up and running");
    }

    public void installPlugins(List<String> plugins) {
        for (String pluginName : plugins) {
            this.executeCommand("install-plugin", pluginName);
        }
        this.restart();
    }

    private void restart() {
        if (OS.contains("win") || OS_VERSION.contains("microsoft")) {
            this.hardRestart();
        } else {
            this.safeRestart();
        }
    }

    private void hardRestart() {
        try {
            this.safeShutdown();
            this.process.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void shutdown() {
        this.process.getJenkinsLogWatcher().close();
        this.executeCommand("shutdown");
        this.process.stop();
    }

    public void safeShutdown() {
        this.process.getJenkinsLogWatcher().close();
        this.executeCommand("safe-shutdown");
        this.process.stop();
    }

    private void safeRestart() {
        this.executeCommand("safe-restart");
        this.process.waitUntil("Jenkins is fully up and running");
    }

    public void setExternalBuildResult(String projectName, String result) {
        this.executeCommand("set-external-build-result", "--job", projectName, "--result", result, "--log", String.format("%s finished with %s", projectName, result));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int executeGroovy(Promise<Matcher, ?, ?> promise, String ... groovyScriptLines) throws InterruptedException {
        String script = String.join((CharSequence)";\n", groovyScriptLines);
        InputStream stdIn = System.in;
        try {
            System.setIn(this.withInput(script));
            int result = this.executeCommand("groovy", "=");
            promise.waitSafely(300000L);
            int n = result;
            return n;
        }
        finally {
            System.setIn(stdIn);
        }
    }

    private int executeCommand(String ... args) {
        try {
            ArrayList<String> cliArgs = new ArrayList<String>(List.of("-s", this.jenkinsUrl.toString(), "-http"));
            cliArgs.addAll(List.of(args));
            return CLI._main((String[])cliArgs.toArray(new String[0]));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Couldn't connect to Jenkins at '%s'", this.jenkinsUrl), e);
        }
    }

    private InputStream withInput(String text) {
        return new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8));
    }
}

